/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wall.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityReplyMessage;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.ecm.rating.api.LikeStatus;
import org.nuxeo.ecm.wall.WallActivityStreamPageProvider;

@Operation(id="Services.GetWallActivityStream", category="Services", label="Get a wall activity stream", description="Get a wall activity stream for the given document.")
public class GetWallActivityStream {
    public static final String ID = "Services.GetWallActivityStream";
    public static final String PROVIDER_NAME = "wall_activity_stream";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Context
    protected LikeService likeService;
    @Param(name="activityStreamName", required=false)
    protected String activityStreamName;
    @Param(name="activityLinkBuilder", required=false)
    protected String activityLinkBuilder;
    @Param(name="contextPath", required=true)
    protected String contextPath;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="limit", required=false)
    protected Integer limit;

    @OperationMethod
    public Blob run() throws Exception {
        Long targetOffset = 0L;
        if (this.offset != null) {
            targetOffset = this.offset.longValue();
        }
        Long targetLimit = null;
        if (this.limit != null) {
            targetLimit = this.limit.longValue();
        }
        DocumentModel doc = this.session.getDocument((DocumentRef)new PathRef(this.contextPath));
        if (StringUtils.isBlank((String)this.activityStreamName)) {
            this.activityStreamName = "socialWorkspaceWallActivityStream";
        }
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("activityStreamName", this.activityStreamName);
        props.put("activityLinkBuilderName", this.activityLinkBuilder);
        props.put("contextDocument", doc);
        props.put("locale", locale);
        props.put("coreSession", (Serializable)this.session);
        PageProvider pageProvider = this.pageProviderService.getPageProvider(PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
        pageProvider.setCurrentPageOffset(targetOffset.longValue());
        List activityMessages = pageProvider.getCurrentPage();
        ArrayList<Map> activitiesJSON = new ArrayList<Map>();
        for (ActivityMessage activityMessage : activityMessages) {
            Map o = activityMessage.toMap(this.session, locale, this.activityLinkBuilder);
            o.put("replies", this.toActivityReplyMessagesJSON(this.session, locale, activityMessage.getActivityReplyMessages()));
            if (activityMessage.getVerb().equals("minimessage")) {
                o.put("allowDeletion", this.getAllowDeletion(activityMessage.getActor()));
            }
            o.put("likeStatus", this.getLikeStatus(activityMessage.getActivityId()));
            activitiesJSON.add(o);
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("offset", Long.valueOf(((WallActivityStreamPageProvider)pageProvider).getNextOffset()));
        m.put("limit", Long.valueOf(pageProvider.getPageSize()));
        m.put("activities", activitiesJSON);
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, m);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }

    private List<Map<String, Object>> toActivityReplyMessagesJSON(CoreSession session, Locale locale, List<ActivityReplyMessage> activityReplyMessages) throws ClientException {
        ArrayList<Map<String, Object>> replies = new ArrayList<Map<String, Object>>();
        for (ActivityReplyMessage activityReplyMessage : activityReplyMessages) {
            Map o = activityReplyMessage.toMap(session, locale, this.activityLinkBuilder);
            o.put("allowDeletion", this.getAllowDeletion(activityReplyMessage.getActor()));
            o.put("likeStatus", this.getLikeStatus((Serializable)((Object)activityReplyMessage.getActivityReplyId())));
            replies.add(o);
        }
        return replies;
    }

    private boolean getAllowDeletion(String actor) {
        String actorUsername = ActivityHelper.getUsername((String)actor);
        return this.session.getPrincipal().getName().equals(actorUsername);
    }

    private Map<String, Serializable> getLikeStatus(Serializable id) {
        String activityObject = ActivityHelper.createActivityObject((Serializable)id);
        LikeStatus likeStatus = this.likeService.getLikeStatus(this.session.getPrincipal().getName(), activityObject);
        return likeStatus.toMap();
    }
}

