/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.JSONBatchBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class BatchManagerComponent
extends DefaultComponent
implements BatchManager {
    protected ConcurrentHashMap<String, Batch> batches = new ConcurrentHashMap();
    protected static final String DEFAULT_CONTEXT = "None";
    protected static final Log log = LogFactory.getLog(BatchManagerComponent.class);

    @Override
    public String initBatch(String batchId, String contextName) {
        Batch batch = this.initBatchInternal(batchId, contextName);
        return batch.id;
    }

    protected Batch initBatchInternal(String batchId, String contextName) {
        Batch newBatch;
        Batch existingBatch;
        if (batchId == null || batchId.isEmpty()) {
            batchId = "batchId-" + UUID.randomUUID().toString();
        }
        if (contextName == null || contextName.isEmpty()) {
            contextName = DEFAULT_CONTEXT;
        }
        if ((existingBatch = this.batches.putIfAbsent(batchId, newBatch = new Batch(batchId))) != null) {
            return existingBatch;
        }
        return newBatch;
    }

    @Override
    public void addStream(String batchId, String idx, InputStream is, String name, String mime) throws IOException {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            batch = this.initBatchInternal(batchId, null);
        }
        batch.addStream(idx, is, name, mime);
    }

    @Override
    public List<Blob> getBlobs(String batchId) {
        return this.getBlobs(batchId, 0);
    }

    @Override
    public List<Blob> getBlobs(String batchId, int timeoutS) {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return Collections.emptyList();
        }
        return batch.getBlobs(timeoutS);
    }

    @Override
    public Blob getBlob(String batchId, String fileId) {
        return this.getBlob(batchId, fileId, 0);
    }

    @Override
    public Blob getBlob(String batchId, String fileId, int timeoutS) {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return null;
        }
        return batch.getBlob(fileId, timeoutS);
    }

    @Override
    public void clean(String batchId) {
        Batch batch = this.batches.get(batchId);
        if (batch != null) {
            batch.clear();
            this.batches.remove(batchId);
        }
    }

    @Override
    public Object execute(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) throws ClientException {
        List<Blob> blobs = this.getBlobs(batchId, this.getUploadWaitTimeout());
        if (blobs == null) {
            String message = String.format("Unable to find batch associated with id '%s'", batchId);
            log.error((Object)message);
            throw new ClientException(message);
        }
        return this.execute(new BlobList(blobs), chainOrOperationId, session, contextParams, operationParams);
    }

    @Override
    public Object execute(String batchId, String fileIdx, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) throws ClientException {
        Blob blob = this.getBlob(batchId, fileIdx, this.getUploadWaitTimeout());
        if (blob == null) {
            String message = String.format("Unable to find batch associated with id '%s' or file associated with index '%s'", batchId, fileIdx);
            log.error((Object)message);
            throw new ClientException(message);
        }
        return this.execute(blob, chainOrOperationId, session, contextParams, operationParams);
    }

    protected Object execute(Object blobInput, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) throws ClientException {
        if (contextParams == null) {
            contextParams = new HashMap<String, Object>();
        }
        if (operationParams == null) {
            operationParams = new HashMap<String, Object>();
        }
        OperationContext ctx = new OperationContext(session);
        ctx.setInput(blobInput);
        ctx.putAll(contextParams);
        try {
            Object result = null;
            AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
            if (chainOrOperationId.startsWith("Chain.")) {
                ctx.putAll(operationParams);
                result = as.run(ctx, chainOrOperationId.substring(6));
            } else {
                OperationChain chain = new OperationChain("operation");
                OperationParameters params = new OperationParameters(chainOrOperationId, operationParams);
                chain.add(params);
                result = as.run(ctx, chain);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Error while executing automation batch ", (Throwable)e);
            throw ClientException.wrap((Throwable)e);
        }
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        try {
            return Integer.parseInt(t);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Wrong number format for upload wait timeout property", (Throwable)e);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeAndClean(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) throws ClientException {
        try {
            Object object = this.execute(batchId, chainOrOperationId, session, contextParams, operationParams);
            return object;
        }
        finally {
            this.clean(batchId);
        }
    }

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONBatchBlobDecoder());
    }
}

