/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util;

import java.util.ArrayList;

public abstract class EntryFilter {
    public static final EntryFilter ANY = new EntryFilter(){

        @Override
        public boolean match(String name) {
            return true;
        }
    };

    public static EntryFilter newFilter(String pattern) {
        if (pattern == null || pattern.equals("*")) {
            return ANY;
        }
        ArrayList<String> parts = new ArrayList<String>();
        int s = 0;
        boolean startAny = false;
        boolean endAny = false;
        if (pattern.startsWith("*")) {
            ++s;
            startAny = true;
        }
        int i = pattern.indexOf(42, s);
        while (i > -1) {
            parts.add(pattern.substring(s, i));
            s = i + 1;
            i = pattern.indexOf(42, s);
        }
        if (s < pattern.length()) {
            parts.add(pattern.substring(s));
        }
        if (s == pattern.length()) {
            endAny = true;
        }
        if (parts.isEmpty()) {
            return new ExactMatch(pattern);
        }
        return new Filter(parts.toArray(new String[parts.size()]), startAny, endAny);
    }

    public abstract boolean match(String var1);

    static class Filter
    extends EntryFilter {
        protected String[] parts;
        protected boolean startAny;
        protected boolean endAny;

        public Filter(String[] parts, boolean startAny, boolean endAny) {
            this.startAny = startAny;
            this.endAny = endAny;
            this.parts = parts;
        }

        @Override
        public boolean match(String name) {
            int len = name.length();
            int i = 0;
            int p = 0;
            if (this.startAny) {
                i = name.indexOf(this.parts[p]);
                if (i == -1) {
                    return false;
                }
                i += this.parts[p++].length();
            } else {
                if (!name.startsWith(this.parts[p])) {
                    return false;
                }
                i += this.parts[p++].length();
            }
            while (i < len && p < this.parts.length) {
                if ((i = name.indexOf(this.parts[p], i)) == -1) {
                    return false;
                }
                i += this.parts[p++].length();
            }
            if (p < this.parts.length) {
                return p == this.parts.length - 1 && this.endAny;
            }
            if (i < len) {
                return this.endAny;
            }
            return true;
        }
    }

    static class ExactMatch
    extends EntryFilter {
        protected String pattern;

        public ExactMatch(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean match(String name) {
            return name.equals(this.pattern);
        }
    }
}

