/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.picture.api.BlobHelper;
import org.nuxeo.ecm.platform.picture.api.adapters.AbstractPictureAdapter;
import org.nuxeo.runtime.api.Framework;

public class DefaultPictureAdapter
extends AbstractPictureAdapter {
    private static final Log log = LogFactory.getLog(DefaultPictureAdapter.class);
    private static final String VIEW_XPATH = "picture:views/item[%d]/";
    private static final String TITLE_PROPERTY = "title";
    private static final String FILENAME_PROPERTY = "filename";

    @Override
    public boolean createPicture(Blob blob, String filename, String title, ArrayList<Map<String, Object>> pictureTemplates) throws IOException, ClientException {
        boolean validFilename;
        if (blob == null) {
            this.clearViews();
            return true;
        }
        this.file = BlobHelper.getFileFromBlob(blob);
        CommandLineExecutorService commandLineExecutorService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        boolean bl = validFilename = this.file == null || commandLineExecutorService.isValidParameter(this.file.getName());
        if (this.file == null || !validFilename) {
            String extension = ".jpg";
            if (this.file != null) {
                extension = "." + FileUtils.getFileExtension((String)this.file.getName());
            }
            this.file = File.createTempFile("nuxeoImage", extension);
            Framework.trackFile((File)this.file, (Object)this);
            blob.transferTo(this.file);
            if (!blob.isPersistent() || !validFilename) {
                blob = new FileBlob(this.file, blob.getMimeType(), blob.getEncoding(), blob.getFilename(), blob.getDigest());
            }
        }
        this.fileContent = blob;
        this.type = blob.getMimeType();
        if (this.type == null || this.type.equals("application/octet-stream")) {
            this.type = this.getImagingService().getImageMimeType(this.file);
            blob.setMimeType(this.type);
        }
        if (this.type == null || this.type.equals("application/octet-stream")) {
            return false;
        }
        try {
            this.setMetadata();
        }
        catch (Exception e) {
            log.debug((Object)("An error occured while trying to set metadata for " + filename), (Throwable)e);
        }
        if (this.width != null && this.height != null) {
            this.clearViews();
            this.addViews(pictureTemplates, filename, title);
        }
        return true;
    }

    @Override
    public void doRotate(int angle) throws ClientException {
        int size = this.doc.getProperty("picture:views").size();
        for (int i = 0; i < size; ++i) {
            String xpath = "picture:views/view[" + i + "]/";
            try {
                SimpleBlobHolder blob = new SimpleBlobHolder((Blob)this.doc.getProperty(xpath + "content").getValue(Blob.class));
                String type = blob.getBlob().getMimeType();
                if (type == "image/png") continue;
                HashMap<String, Integer> options = new HashMap<String, Integer>();
                options.put("angle", angle);
                blob = this.getConversionService().convert("pictureRotation", (BlobHolder)blob, options);
                this.doc.getProperty(xpath + "content").setValue((Object)blob.getBlob());
                Long height = (Long)this.doc.getProperty(xpath + "height").getValue();
                Long width = (Long)this.doc.getProperty(xpath + "width").getValue();
                this.doc.getProperty(xpath + "height").setValue((Object)width);
                this.doc.getProperty(xpath + "width").setValue((Object)height);
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Rotation Failed", (Throwable)e);
            }
        }
    }

    @Override
    public void doCrop(String coords) throws ClientException {
        this.doc.setPropertyValue("picture:cropCoords", (Serializable)((Object)coords));
    }

    @Override
    public Blob getPictureFromTitle(String title) throws PropertyException, ClientException {
        if (title == null) {
            return null;
        }
        Collection views = this.doc.getProperty("picture:views").getChildren();
        for (Property property : views) {
            if (!title.equals(property.getValue(TITLE_PROPERTY))) continue;
            Blob blob = (Blob)property.getValue("content");
            blob.setFilename((String)((Object)property.getValue(FILENAME_PROPERTY)));
            return blob;
        }
        return null;
    }

    @Override
    public String getFirstViewXPath() {
        return this.getViewXPathFor(0);
    }

    @Override
    public String getViewXPath(String viewName) {
        try {
            Property views = this.doc.getProperty("picture:views");
            for (int i = 0; i < views.size(); ++i) {
                if (!views.get(i).getValue(TITLE_PROPERTY).equals(viewName)) continue;
                return this.getViewXPathFor(i);
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get picture views", (Throwable)e);
        }
        return null;
    }

    protected String getViewXPathFor(int index) {
        return String.format(VIEW_XPATH, index);
    }
}

