/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;

public class TaskImpl
implements Task {
    private static final long serialVersionUID = 1L;
    private DocumentModel doc;

    public TaskImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    @Override
    public String getId() {
        return this.doc.getId();
    }

    @Override
    public String getTargetDocumentId() {
        return (String)this.getPropertyValue("nt:targetDocumentId");
    }

    @Override
    public List<String> getActors() throws ClientException {
        return (List)this.getPropertyValue("nt:actors");
    }

    @Override
    public String getInitiator() throws ClientException {
        return (String)this.getPropertyValue("nt:initiator");
    }

    @Override
    public String getDescription() throws ClientException {
        return (String)this.getPropertyValue("dublincore:description");
    }

    @Override
    public String getDirective() throws ClientException {
        return (String)this.getPropertyValue("nt:directive");
    }

    @Override
    public List<TaskComment> getComments() throws ClientException {
        List taskCommentsProperty = (List)this.getPropertyValue("nt:taskComments");
        ArrayList<TaskComment> taskComments = new ArrayList<TaskComment>(taskCommentsProperty.size());
        for (Map taskCommentMap : taskCommentsProperty) {
            taskComments.add(new TaskComment(taskCommentMap));
        }
        return taskComments;
    }

    @Override
    public String getName() throws ClientException {
        return (String)this.getPropertyValue("nt:name");
    }

    @Override
    public String getType() throws ClientException {
        return (String)this.getPropertyValue("nt:type");
    }

    @Override
    public String getProcessId() throws ClientException {
        return (String)this.getPropertyValue("nt:processId");
    }

    @Override
    public Date getCreated() throws ClientException {
        return this.getDatePropertyValue("dublincore:created");
    }

    @Override
    public Boolean isCancelled() throws ClientException {
        return "cancelled".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public Boolean hasEnded() throws ClientException {
        return "ended".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public Boolean isOpened() throws ClientException {
        return "opened".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public Boolean isAccepted() throws ClientException {
        Boolean isAccepted = (Boolean)this.getPropertyValue("nt:accepted");
        return isAccepted == null ? false : isAccepted;
    }

    @Override
    public String getVariable(String key) throws ClientException {
        Map<String, String> variables = this.getVariables();
        return variables.get(key);
    }

    @Override
    public Date getDueDate() throws ClientException {
        return this.getDatePropertyValue("nt:dueDate");
    }

    @Override
    public Map<String, String> getVariables() throws ClientException {
        List variables = (List)this.getPropertyValue("nt:task_variables");
        HashMap<String, String> variableMap = new HashMap<String, String>(variables.size());
        for (Map map : variables) {
            variableMap.put((String)map.get("key"), (String)map.get("value"));
        }
        return variableMap;
    }

    @Override
    public void setActors(List<String> users) throws ClientException {
        this.setPropertyValue("nt:actors", users);
    }

    @Override
    public void setTargetDocumentId(String targetDocId) throws ClientException {
        this.setPropertyValue("nt:targetDocumentId", targetDocId);
    }

    @Override
    public void setDescription(String description) throws ClientException {
        this.setPropertyValue("dublincore:description", description);
    }

    @Override
    public void setDirective(String directive) throws ClientException {
        this.setPropertyValue("nt:directive", directive);
    }

    @Override
    public void setName(String name) throws ClientException {
        this.setPropertyValue("nt:name", name);
    }

    @Override
    public void setProcessId(String processId) throws ClientException {
        this.setPropertyValue("nt:processId", processId);
    }

    @Override
    public void setType(String type) throws ClientException {
        this.setPropertyValue("nt:type", type);
    }

    @Override
    public void setInitiator(String initiator) throws ClientException {
        this.setPropertyValue("nt:initiator", initiator);
    }

    @Override
    public void setDueDate(Date dueDate) throws ClientException {
        this.setPropertyValue("nt:dueDate", dueDate);
    }

    @Override
    public void setCreated(Date created) throws ClientException {
        this.setPropertyValue("dublincore:created", created);
    }

    @Override
    public void cancel(CoreSession coreSession) throws ClientException {
        this.followTransition(coreSession, "cancel");
    }

    @Override
    public void end(CoreSession coreSession) throws ClientException {
        this.followTransition(coreSession, "end");
    }

    protected void followTransition(CoreSession coreSession, String transition) throws ClientException {
        if (!this.doc.getAllowedStateTransitions().contains(transition)) {
            throw new ClientRuntimeException("Cannot follow transition " + transition + " on the document " + this.doc.getPathAsString());
        }
        coreSession.followTransition(this.doc.getRef(), transition);
    }

    @Override
    public void setAccepted(Boolean accepted) throws ClientException {
        this.setPropertyValue("nt:accepted", accepted);
    }

    @Override
    public void setVariables(Map<String, String> variables) throws ClientException {
        ArrayList variablesProperty = (ArrayList)this.getPropertyValue("nt:task_variables");
        if (variablesProperty == null) {
            variablesProperty = new ArrayList();
        }
        for (String key : variables.keySet()) {
            String value = variables.get(key);
            if (!(value instanceof String)) continue;
            HashMap<String, Object> variable = new HashMap<String, Object>(1);
            variable.put("key", key);
            variable.put("value", (Serializable)((Object)value));
            variablesProperty.add(variable);
        }
        this.setPropertyValue("nt:task_variables", variablesProperty);
    }

    @Override
    public void setVariable(String key, String value) throws ClientException {
        ArrayList variables = (ArrayList)this.getPropertyValue("nt:task_variables");
        if (variables == null) {
            variables = new ArrayList();
        }
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        variableMap.put("key", key);
        variableMap.put("value", value);
        variables.add(variableMap);
        this.setPropertyValue("nt:task_variables", variables);
    }

    @Override
    public void addComment(String author, String text) throws ClientException {
        ArrayList<TaskComment> existingTasks = (ArrayList<TaskComment>)this.getPropertyValue("nt:taskComments");
        if (existingTasks == null) {
            existingTasks = new ArrayList<TaskComment>();
        }
        existingTasks.add(new TaskComment(author, text));
        this.setPropertyValue("nt:taskComments", existingTasks);
    }

    protected <T> T getPropertyValue(String propertyName) {
        try {
            return (T)this.doc.getPropertyValue(propertyName);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Date getDatePropertyValue(String propertyName) {
        try {
            Calendar cal = (Calendar)this.doc.getPropertyValue(propertyName);
            if (cal != null) {
                return cal.getTime();
            }
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return null;
    }

    protected void setPropertyValue(String propertyName, Object value) {
        try {
            if (value != null) {
                if (value instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)value);
                    this.doc.setPropertyValue(propertyName, (Serializable)cal);
                } else {
                    this.doc.setPropertyValue(propertyName, (Serializable)value);
                }
            }
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

