/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.util.Map;
import javax.faces.event.PhaseId;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;

@Interceptor
public class NuxeoExceptionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    protected PhaseId getPhase() {
        return FacesLifecycle.getPhaseId();
    }

    protected StatusMessage.Severity getSeverity(RecoverableClientException ce) {
        if (ce.getSeverity() == RecoverableClientException.Severity.WARN) {
            return StatusMessage.Severity.WARN;
        }
        if (ce.getSeverity() == RecoverableClientException.Severity.FATAL) {
            return StatusMessage.Severity.FATAL;
        }
        return StatusMessage.Severity.ERROR;
    }

    protected String getI18nMessage(String messageKey) {
        Map messages = (Map)Component.getInstance((String)"org.jboss.seam.international.messages", (boolean)true);
        if (messages == null) {
            return messageKey;
        }
        String i18nMessage = (String)messages.get(messageKey);
        if (i18nMessage != null) {
            return i18nMessage;
        }
        return messageKey;
    }

    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        try {
            return invocationContext.proceed();
        }
        catch (Exception t) {
            Throwable unwrappedException = ExceptionHelper.unwrapException((Throwable)t);
            if (unwrappedException instanceof RecoverableClientException) {
                RecoverableClientException ce = (RecoverableClientException)unwrappedException;
                StatusMessage.Severity severity = this.getSeverity(ce);
                FacesMessages.instance().add(severity, this.getI18nMessage(ce.getLocalizedMessage()), (Object[])ce.geLocalizedMessageParams());
                return null;
            }
            throw t;
        }
    }

    public boolean isInterceptorEnabled() {
        PhaseId phase = this.getPhase();
        if (phase == null) {
            return true;
        }
        return phase.equals(PhaseId.INVOKE_APPLICATION);
    }
}

