/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileImporter
implements FileImporter {
    private static final long serialVersionUID = 1L;
    protected String name = "";
    protected String docType;
    protected List<String> filters = new ArrayList<String>();
    protected List<Pattern> patterns;
    protected boolean enabled = true;
    protected Integer order = 0;
    public static final String SKIP_UPDATE_AUDIT_LOGGING = "org.nuxeo.filemanager.skip.audit.logging.forupdates";
    public static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    protected FileManagerService fileManagerService;

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<String> filters) {
        this.filters = filters;
        this.patterns = new ArrayList<Pattern>();
        for (String filter : filters) {
            this.patterns.add(Pattern.compile(filter));
        }
    }

    @Override
    public boolean matches(String mimeType) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(mimeType).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDocType() {
        return this.docType;
    }

    @Override
    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getDocType(DocumentModel container) {
        return this.getDocType();
    }

    public String getDefaultDocType() {
        throw new UnsupportedOperationException();
    }

    public boolean isOverwriteByTitle() {
        throw new UnsupportedOperationException();
    }

    public void createDocument(DocumentModel doc, Blob content, String title) throws ClientException {
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    public void updateDocument(DocumentModel doc, Blob content) throws ClientException {
        try {
            content = content.persist();
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        ((BlobHolder)doc.getAdapter(BlobHolder.class)).setBlob(content);
    }

    public Blob getBlob(DocumentModel doc) throws ClientException {
        return ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
    }

    @Override
    public DocumentModel create(CoreSession session, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        DocumentModel container = session.getDocument((DocumentRef)new PathRef(path = this.getNearestContainerPath(session, path)));
        String docType = this.getDocType(container);
        if (docType == null) {
            docType = this.getDefaultDocType();
        }
        this.doSecurityCheck(session, path, docType, typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        content.setFilename(filename);
        DocumentModel doc = this.isOverwriteByTitle() ? FileManagerUtils.getExistingDocByTitle((CoreSession)session, (String)path, (String)title) : FileManagerUtils.getExistingDocByFileName((CoreSession)session, (String)path, (String)filename);
        boolean skipCheckInAfterAdd = false;
        if (overwrite && doc != null) {
            if (!this.skipCheckInForBlob(this.getBlob(doc))) {
                this.checkIn(doc);
            }
            this.updateDocument(doc, content);
            if (Framework.getProperty((String)SKIP_UPDATE_AUDIT_LOGGING, (String)"false").equalsIgnoreCase("true")) {
                doc.putContextData(DISABLE_AUDIT_LOGGER, (Serializable)Boolean.valueOf(true));
            }
            doc = doc.getCoreSession().saveDocument(doc);
        } else {
            doc = session.createDocumentModel(docType);
            this.createDocument(doc, content, title);
            PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
            doc.setPathInfo(path, pss.generatePathSegment(doc));
            this.updateDocument(doc, content);
            skipCheckInAfterAdd = this.skipCheckInForBlob(content);
            doc = session.createDocument(doc);
        }
        if (!skipCheckInAfterAdd) {
            this.checkInAfterAdd(doc);
        }
        session.save();
        return doc;
    }

    protected boolean skipCheckInForBlob(Blob blob) {
        return blob == null || blob.getLength() == 0L;
    }

    public FileManagerService getFileManagerService() {
        return this.fileManagerService;
    }

    @Override
    public void setFileManagerService(FileManagerService fileManagerService) {
        this.fileManagerService = fileManagerService;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public int compareTo(FileImporter other) {
        Integer otherOrder = other.getOrder();
        if (this.order == null && otherOrder == null) {
            return 0;
        }
        if (this.order == null) {
            return 1;
        }
        if (otherOrder == null) {
            return -1;
        }
        return this.order.compareTo(otherOrder);
    }

    protected TypeManager getTypeService() throws ClientException {
        try {
            return (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected String getNearestContainerPath(CoreSession documentManager, String path) throws ClientException {
        DocumentModel currentDocument = documentManager.getDocument((DocumentRef)new PathRef(path));
        if (!currentDocument.isFolder()) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        return path;
    }

    protected void checkIn(DocumentModel doc) throws ClientException {
        VersioningOption option = this.fileManagerService.getVersioningOption();
        if (option != null && option != VersioningOption.NONE && doc.isCheckedOut()) {
            doc.checkIn(option, null);
        }
    }

    protected void checkInAfterAdd(DocumentModel doc) throws ClientException {
        if (this.fileManagerService.doVersioningAfterAdd()) {
            this.checkIn(doc);
        }
    }

    @Deprecated
    protected DocumentModel overwriteAndIncrementversion(CoreSession documentManager, DocumentModel doc) throws ClientException {
        doc.putContextData("VersioningOption", (Serializable)this.fileManagerService.getVersioningOption());
        return documentManager.saveDocument(doc);
    }

    protected void doSecurityCheck(CoreSession documentManager, String path, String typeName, TypeManager typeService) throws DocumentSecurityException, ClientException {
        PathRef containerRef = new PathRef(path);
        if (!documentManager.hasPermission((DocumentRef)containerRef, "ReadProperties") || !documentManager.hasPermission((DocumentRef)containerRef, "AddChildren")) {
            throw new DocumentSecurityException("Not enough rights to create folder");
        }
        DocumentModel container = documentManager.getDocument((DocumentRef)containerRef);
        Type containerType = typeService.getType(container.getType());
        if (containerType == null) {
            return;
        }
        if (!typeService.isAllowedSubType(typeName, container.getType(), container)) {
            throw new ClientException(String.format("Cannot create document of type %s in container with type %s", typeName, containerType.getId()));
        }
    }
}

