/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class AsyncEventExecutor {
    private static final Log log = LogFactory.getLog(AsyncEventExecutor.class);

    public WorkManager getWorkManager() {
        return (WorkManager)Framework.getLocalService(WorkManager.class);
    }

    public void init() {
        WorkManager workManager = this.getWorkManager();
        if (workManager != null) {
            workManager.init();
        }
    }

    public boolean shutdown(long timeoutMillis) throws InterruptedException {
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            return true;
        }
        return workManager.shutdown(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public boolean waitForCompletion(long timeoutMillis) throws InterruptedException {
        WorkManager workManager = this.getWorkManager();
        return workManager.awaitCompletion(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle) {
        for (EventListenerDescriptor listener : listeners) {
            EventBundle filtered = listener.filterBundle(bundle);
            if (filtered.isEmpty()) continue;
            this.getWorkManager().schedule(new ListenerWork(listener, filtered));
        }
    }

    public int getUnfinishedCount() {
        WorkManager workManager = this.getWorkManager();
        int n = 0;
        for (String queueId : workManager.getWorkQueueIds()) {
            n += workManager.getNonCompletedWorkSize(queueId);
        }
        return n;
    }

    public int getActiveCount() {
        WorkManager workManager = this.getWorkManager();
        int n = 0;
        for (String queueId : workManager.getWorkQueueIds()) {
            n += workManager.listWork(queueId, Work.State.RUNNING).size();
        }
        return n;
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger();
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String namePrefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.namePrefix = prefix + ' ' + poolNumber.incrementAndGet() + '-';
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.threadNumber.incrementAndGet();
            Thread t = new Thread(this.group, r, name);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }

    protected static class ListenerWork
    extends AbstractWork {
        protected final String title;
        protected ReconnectedEventBundle bundle;
        protected EventListenerDescriptor listener;

        public ListenerWork(EventListenerDescriptor listener, EventBundle bundle) {
            this.listener = listener;
            this.bundle = bundle instanceof ReconnectedEventBundle ? (ReconnectedEventBundle)bundle : new ReconnectedEventBundleImpl(bundle, listener.getName());
            LinkedList<String> l = new LinkedList<String>();
            for (Event event : bundle) {
                DocumentModel source;
                String s = event.getName();
                EventContext ctx = event.getContext();
                if (ctx instanceof DocumentEventContext && (source = ((DocumentEventContext)ctx).getSourceDocument()) != null) {
                    s = s + "/" + source.getRef();
                }
                l.add(s);
            }
            this.title = "Listener " + listener.getName() + " " + l;
        }

        @Override
        public String getCategory() {
            return this.listener.getName();
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public Collection<DocumentLocation> getDocuments() {
            return Collections.emptyList();
        }

        @Override
        public void work() throws Exception {
            this.listener.asPostCommitListener().handleEvent(this.bundle);
        }

        @Override
        public void cleanUp(boolean ok, Exception e) {
            EventStats stats;
            this.bundle.disconnect();
            if (e != null && !(e instanceof InterruptedException)) {
                log.error((Object)("Failed to execute async event " + this.bundle.getName() + " on listener " + this.listener.getName()), (Throwable)e);
            }
            if ((stats = (EventStats)Framework.getLocalService(EventStats.class)) != null) {
                stats.logAsyncExec(this.listener, System.currentTimeMillis() - this.startTime);
            }
            this.bundle = null;
            this.listener = null;
        }
    }
}

