/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractWork
implements Work {
    private static final Log log = LogFactory.getLog(AbstractWork.class);
    protected volatile Work.State state;
    protected volatile Work.Progress progress;
    protected volatile String status;
    protected Object stateMonitor = new Object();
    protected long schedulingTime;
    protected volatile long startTime;
    protected volatile long completionTime;
    protected volatile Map<String, Serializable> data;
    protected volatile boolean isTransactionStarted = false;

    public AbstractWork() {
        this.state = Work.State.SCHEDULED;
        this.progress = Work.Progress.PROGRESS_INDETERMINATE;
        this.schedulingTime = System.currentTimeMillis();
    }

    @Override
    public void setData(Map<String, Serializable> data) {
        this.data = data;
    }

    protected void setProgress(Work.Progress progress) {
        this.progress = progress;
    }

    @Override
    public Work.Progress getProgress() {
        return this.progress;
    }

    protected void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeRun() {
        this.startTime = System.currentTimeMillis();
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == Work.State.SCHEDULED) {
                this.state = Work.State.RUNNING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.state == Work.State.SUSPENDED) {
            return;
        }
        boolean tx = this.isTransactional();
        if (tx) {
            this.isTransactionStarted = TransactionHelper.startTransaction();
        }
        boolean ok = false;
        Exception err = null;
        try {
            this.work();
            ok = true;
        }
        catch (Exception e) {
            err = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.cleanUp(ok, err);
            }
            finally {
                try {
                    if (tx && this.isTransactionStarted) {
                        if (!ok) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                        this.isTransactionStarted = false;
                    }
                }
                finally {
                    if (err instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public abstract void work() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRun(boolean ok) {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (!ok) {
                this.state = Work.State.FAILED;
            } else if (this.state == Work.State.RUNNING || this.state == Work.State.SUSPENDING) {
                this.state = Work.State.COMPLETED;
            }
        }
        if (this.state == Work.State.COMPLETED) {
            this.setProgress(Work.Progress.PROGRESS_100_PC);
        }
        this.completionTime = System.currentTimeMillis();
    }

    public void cleanUp(boolean ok, Exception e) {
        if (ok || e instanceof InterruptedException) {
            return;
        }
        log.error((Object)("Exception during work: " + this), (Throwable)e);
    }

    protected boolean isTransactional() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspend() {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != Work.State.COMPLETED && this.state != Work.State.FAILED) {
                if (this.state != Work.State.SUSPENDED) {
                    if (this.state == Work.State.SCHEDULED) {
                        this.suspendFromQueue();
                        this.state = Work.State.SUSPENDED;
                    } else {
                        this.state = Work.State.SUSPENDING;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void suspendFromQueue() {
    }

    protected boolean isSuspending() {
        return this.state == Work.State.SUSPENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspended(Map<String, Serializable> data) {
        this.data = data;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == Work.State.SUSPENDING) {
                this.state = Work.State.SUSPENDED;
            }
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long delay = unit.toMillis(timeout);
        long t0 = System.currentTimeMillis();
        while (this.state == Work.State.RUNNING || this.state == Work.State.SUSPENDING) {
            if (System.currentTimeMillis() - t0 > delay) {
                return false;
            }
            Thread.sleep(50L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled() {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != Work.State.SCHEDULED) {
                throw new IllegalStateException(String.valueOf((Object)this.state));
            }
            this.state = Work.State.CANCELED;
        }
    }

    @Override
    public Map<String, Serializable> getData() {
        return this.data;
    }

    @Override
    public Work.State getState() {
        return this.state;
    }

    @Override
    public long getSchedulingTime() {
        return this.schedulingTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public String getCategory() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.getState()) + ", " + this.getProgress() + ", " + this.getStatus() + ")";
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public Collection<DocumentLocation> getDocuments() {
        return Collections.emptyList();
    }

    protected void commitOrRollbackTransaction() {
        if (this.isTransactional() && this.isTransactionStarted) {
            TransactionHelper.commitOrRollbackTransaction();
            this.isTransactionStarted = false;
        }
    }

    protected boolean startTransaction() {
        if (this.isTransactional() && !this.isTransactionStarted) {
            this.isTransactionStarted = TransactionHelper.startTransaction();
        }
        return this.isTransactionStarted;
    }
}

