/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class SleepWork
extends AbstractWork {
    public static final String STATE_DURATION = "durationMillis";
    protected final long durationMillis;
    protected final String category;
    protected final boolean debug;
    protected CountDownLatch readyLatch = new CountDownLatch(1);
    protected CountDownLatch doneLatch = new CountDownLatch(1);
    protected CountDownLatch startLatch = new CountDownLatch(1);
    protected CountDownLatch finishLatch = new CountDownLatch(1);

    public SleepWork(long durationMillis) {
        this(durationMillis, false);
    }

    public SleepWork(long durationMillis, boolean debug) {
        this(durationMillis, "SleepWork", debug);
    }

    public SleepWork(long durationMillis, String category, boolean debug) {
        this.durationMillis = durationMillis;
        this.category = category;
        this.debug = debug;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTitle() {
        return "Sleep " + this.durationMillis + " ms";
    }

    @Override
    protected void suspendFromQueue() {
        this.suspend(this.durationMillis);
    }

    protected void suspend(long remainingMillis) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(STATE_DURATION, Long.valueOf(remainingMillis));
        this.suspended(map);
    }

    @Override
    public void work() throws InterruptedException {
        long elapsed;
        if (this.debug) {
            this.setStatus("Starting sleep work");
            this.readyLatch.countDown();
            this.startLatch.await();
            this.setStatus("Running sleep work");
        }
        this.startTime = System.currentTimeMillis();
        while ((elapsed = System.currentTimeMillis() - this.startTime) <= this.durationMillis) {
            this.setProgress(new Work.Progress(100.0f * (float)elapsed / (float)this.durationMillis));
            if (this.isSuspending()) {
                this.suspend(this.durationMillis - elapsed);
                this.doneLatch.countDown();
                this.finishLatch.await();
                return;
            }
            Thread.sleep(10L);
        }
        if (this.debug) {
            this.setStatus("Completed sleep work");
            this.setProgress(Work.Progress.PROGRESS_100_PC);
            this.doneLatch.countDown();
            this.finishLatch.await();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.durationMillis + "ms, " + (Object)((Object)this.getState()) + ", " + this.getProgress() + ")";
    }

    public void debugWaitReady() throws InterruptedException {
        this.readyLatch.await();
    }

    public void debugWaitDone() throws InterruptedException {
        this.doneLatch.await();
    }

    public void debugStart() {
        this.startLatch.countDown();
    }

    public void debugFinish() {
        this.finishLatch.countDown();
    }
}

