/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.encoding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuxeoEncodingFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoEncodingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null) {
            if (request.getCharacterEncoding() == null) {
                try {
                    request.setCharacterEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            String requestURI = ((HttpServletRequest)request).getRequestURI();
            String gcfMeta = ",chrome=1";
            if (requestURI != null && requestURI.contains("login.jsp")) {
                gcfMeta = "";
            }
            if (response instanceof HttpServletResponse && !((HttpServletResponse)response).containsHeader("X-UA-Compatible")) {
                ((HttpServletResponse)response).addHeader("X-UA-Compatible", "IE=Edge" + gcfMeta);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

