/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.impl.OperationServiceImpl;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ChainEntryRegistry
extends ContributionFragmentRegistry<OperationServiceImpl.ChainEntry> {
    protected final Map<String, OperationServiceImpl.ChainEntry> chains = new HashMap<String, OperationServiceImpl.ChainEntry>();
    protected volatile Map<String, OperationServiceImpl.ChainEntry> lookup;

    public String getContributionId(OperationServiceImpl.ChainEntry contrib) {
        return contrib.chain.getId();
    }

    public synchronized void addContribution(OperationServiceImpl.ChainEntry chain, boolean replace) throws OperationException {
        String id = chain.chain.getId();
        if (!replace && this.chains.containsKey(id)) {
            throw new OperationException("Chain with id " + id + " already exists");
        }
        super.addContribution((Object)chain);
    }

    public void contributionUpdated(String id, OperationServiceImpl.ChainEntry contrib, OperationServiceImpl.ChainEntry newOrigContrib) {
        this.chains.put(id, contrib);
        this.lookup = null;
    }

    public void contributionRemoved(String id, OperationServiceImpl.ChainEntry origContrib) {
        if (this.chains.remove(id) != null) {
            this.lookup = null;
        }
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public OperationServiceImpl.ChainEntry clone(OperationServiceImpl.ChainEntry orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(OperationServiceImpl.ChainEntry src, OperationServiceImpl.ChainEntry dst) {
        throw new UnsupportedOperationException();
    }

    public OperationServiceImpl.ChainEntry getChainEntry(String id) {
        return this.chains.get(id);
    }

    public synchronized void flushCompiledChains() {
        for (OperationServiceImpl.ChainEntry entry : this.chains.values()) {
            entry.cchain = null;
        }
        this.lookup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OperationServiceImpl.ChainEntry> lookup() {
        Map<String, OperationServiceImpl.ChainEntry> _lookup = this.lookup;
        if (_lookup == null) {
            ChainEntryRegistry chainEntryRegistry = this;
            synchronized (chainEntryRegistry) {
                _lookup = this.lookup = new HashMap<String, OperationServiceImpl.ChainEntry>(this.chains);
            }
        }
        return _lookup;
    }
}

