/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.xmap.AttributeValueVisitor;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.ElementValueVisitor;
import org.nuxeo.common.xmap.ElementVisitor;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.w3c.dom.Element;

public class XAnnotatedList
extends XAnnotatedMember {
    protected static final ElementVisitor elementListVisitor = new ElementVisitor();
    protected static final ElementValueVisitor elementVisitor = new ElementValueVisitor();
    protected static final AttributeValueVisitor attributeVisitor = new AttributeValueVisitor();
    protected Class componentType;
    protected boolean isNullByDefault;

    protected XAnnotatedList(XMap xmap, XAccessor setter) {
        super(xmap, setter);
    }

    public XAnnotatedList(XMap xmap, XAccessor setter, XNodeList anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = anno.type();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
        this.isNullByDefault = anno.nullByDefault();
    }

    @Override
    protected Object getValue(Context ctx, Element base) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.xao != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementListVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        if (this.isNullByDefault && values.isEmpty()) {
            return null;
        }
        if (this.type != ArrayList.class) {
            if (this.type.isArray()) {
                if (this.componentType.isPrimitive()) {
                    return PrimitiveArrays.toPrimitiveArray(values, this.componentType);
                }
                return values.toArray((Object[])Array.newInstance(this.componentType, values.size()));
            }
            Collection col = (Collection)this.type.newInstance();
            col.addAll(values);
            return col;
        }
        return values;
    }

    @Override
    public void toXML(Object instance, Element parent) throws Exception {
        block5: {
            Object v = this.accessor.getValue(instance);
            if (v == null) break block5;
            Object[] objects = null;
            objects = v instanceof Object[] ? (Object[])v : (v instanceof List ? ((List)v).toArray() : (v instanceof Collection ? ((Collection)v).toArray() : PrimitiveArrays.toObjectArray(v)));
            if (objects != null) {
                if (this.xao == null) {
                    for (Object o : objects) {
                        String value = this.valueFactory.serialize(null, o);
                        if (value == null) continue;
                        Element e = XMLBuilder.addElement(parent, this.path);
                        XMLBuilder.fillField(e, value, this.path.attribute);
                    }
                } else {
                    for (Object o : objects) {
                        Element e = XMLBuilder.addElement(parent, this.path);
                        XMLBuilder.toXML(o, e, this.xao);
                    }
                }
            }
        }
    }
}

