/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThresholdOutputStream
extends OutputStream {
    private static final int MAX_GROW = 0xA00000;
    private static final int DEFAULT_THRESHOLD = 0x400000;
    private File tempDir;
    private int memoryThreshold;
    private byte[] buf = null;
    private int bufSize = 0;
    private long size;
    private File tempFile;
    private OutputStream tmpStream;

    public ThresholdOutputStream(File tempDir, int memoryThreshold) {
        this(65536, tempDir, memoryThreshold);
    }

    public ThresholdOutputStream(int initSize, File tempDir, int memoryThreshold) {
        if (initSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initSize);
        }
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold < 0 ? 0x400000 : memoryThreshold;
        this.buf = new byte[initSize];
    }

    private void expand(int nextBufferSize) throws IOException {
        if (this.bufSize + nextBufferSize <= this.buf.length) {
            return;
        }
        if (this.bufSize + nextBufferSize > this.memoryThreshold) {
            if (this.tmpStream == null) {
                this.tempFile = File.createTempFile("opencmis", null, this.tempDir);
                this.tmpStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            }
            this.tmpStream.write(this.buf, 0, this.bufSize);
            if (this.buf.length != this.memoryThreshold) {
                this.buf = new byte[this.memoryThreshold];
            }
            this.bufSize = 0;
            return;
        }
        int newSize = (this.bufSize + nextBufferSize) * 2 < 0xA00000 ? (this.bufSize + nextBufferSize) * 2 : this.buf.length + nextBufferSize + 0xA00000;
        byte[] newbuf = new byte[newSize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
        this.buf = newbuf;
    }

    public long getSize() {
        return this.size;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.expand(len);
        System.arraycopy(buffer, offset, this.buf, this.bufSize, len);
        this.bufSize += len;
        this.size += (long)len;
    }

    public void write(int oneByte) throws IOException {
        if (this.bufSize == this.buf.length) {
            this.expand(1);
        }
        this.buf[this.bufSize++] = (byte)oneByte;
        ++this.size;
    }

    public void flush() throws IOException {
        if (this.tmpStream != null) {
            if (this.bufSize > 0) {
                this.tmpStream.write(this.buf, 0, this.bufSize);
                this.bufSize = 0;
            }
            this.tmpStream.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.tmpStream != null) {
            this.tmpStream.close();
        }
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        this.buf = null;
    }

    public InputStream getInputStream() throws Exception {
        if (this.tmpStream != null) {
            this.close();
            this.buf = null;
            return new InternalTempFileInputStream();
        }
        return new InternalBufferInputStream();
    }

    static /* synthetic */ byte[] access$202(ThresholdOutputStream x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    private class InternalTempFileInputStream
    extends FilterInputStream
    implements ThresholdInputStream {
        private boolean isDeleted;

        public InternalTempFileInputStream() throws FileNotFoundException {
            super(new BufferedInputStream(new FileInputStream(ThresholdOutputStream.this.tempFile), ThresholdOutputStream.this.memoryThreshold));
            this.isDeleted = false;
        }

        public boolean isInMemory() {
            return false;
        }

        public File getTemporaryFile() {
            return ThresholdOutputStream.this.tempFile;
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            int b = super.read();
            if (b == -1 && !this.isDeleted) {
                super.close();
                this.isDeleted = ThresholdOutputStream.this.tempFile.delete();
            }
            return b;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n == -1 && !this.isDeleted) {
                super.close();
                this.isDeleted = ThresholdOutputStream.this.tempFile.delete();
            }
            return n;
        }

        public void close() throws IOException {
            if (!this.isDeleted) {
                super.close();
                this.isDeleted = ThresholdOutputStream.this.tempFile.delete();
            }
        }
    }

    private class InternalBufferInputStream
    extends InputStream
    implements ThresholdInputStream {
        private int pos = 0;

        private InternalBufferInputStream() {
        }

        public boolean isInMemory() {
            return true;
        }

        public File getTemporaryFile() {
            return null;
        }

        public boolean markSupported() {
            return false;
        }

        public int available() {
            return ThresholdOutputStream.this.bufSize - this.pos;
        }

        public int read() {
            return this.pos < ThresholdOutputStream.this.bufSize && ThresholdOutputStream.this.buf != null ? ThresholdOutputStream.this.buf[this.pos++] & 0xFF : -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (this.pos >= ThresholdOutputStream.this.bufSize || ThresholdOutputStream.this.buf == null) {
                return -1;
            }
            if (this.pos + len > ThresholdOutputStream.this.bufSize) {
                len = ThresholdOutputStream.this.bufSize - this.pos;
            }
            System.arraycopy(ThresholdOutputStream.this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public long skip(long n) {
            if ((long)this.pos + n > (long)ThresholdOutputStream.this.bufSize) {
                n = ThresholdOutputStream.this.bufSize - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        public void close() throws IOException {
            ThresholdOutputStream.access$202(ThresholdOutputStream.this, null);
        }
    }

    public static interface ThresholdInputStream {
        public boolean isInMemory();

        public File getTemporaryFile();
    }
}

