/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.syndication.FeedItem;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class FeedItemAdapter {
    private FeedItemAdapter() {
    }

    public static FeedItem toFeedItem(DocumentModel doc, HttpServletRequest req) throws ClientException {
        FeedItem feedIt = new FeedItem();
        feedIt.setTitle((String)doc.getProperty("dublincore", "title"));
        feedIt.setDescription((String)doc.getProperty("dublincore", "description"));
        Object[] contribs = (Object[])doc.getProperty("dublincore", "contributors");
        ArrayList<String> contributors = new ArrayList<String>(contribs.length);
        for (Object contrib : contribs) {
            contributors.add((String)contrib);
        }
        feedIt.setAuthor((String)contributors.get(0));
        feedIt.setContributors(contributors);
        feedIt.setLink(DocumentModelFunctions.documentUrl(null, (DocumentModel)doc, null, null, (boolean)true, (HttpServletRequest)req));
        Date creationDate = ((Calendar)doc.getProperty("dublincore", "created")).getTime();
        Date updateDate = ((Calendar)doc.getProperty("dublincore", "modified")).getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            feedIt.setPublishedDate(dateFormat.parse(dateFormat.format(creationDate)));
            feedIt.setUpdatedDate(dateFormat.parse(dateFormat.format(updateDate)));
        }
        catch (ParseException e) {
            throw new ClientException((Throwable)e);
        }
        return feedIt;
    }

    public static List<FeedItem> toFeedItemList(List<DocumentModel> docList, HttpServletRequest req) throws ClientException {
        ArrayList<FeedItem> feedItems = new ArrayList<FeedItem>(docList.size());
        for (DocumentModel doc : docList) {
            feedItems.add(FeedItemAdapter.toFeedItem(doc, req));
        }
        return feedItems;
    }
}

