/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.framework.HibernateEntityIdentifier;
import org.jboss.seam.framework.Identifier;
import org.jboss.seam.ui.AbstractEntityLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.ui.entityLoader")
@Install(precedence=10, classDependencies={"org.hibernate.Session"}, value=false)
@Scope(value=ScopeType.STATELESS)
public class HibernateEntityLoader
extends AbstractEntityLoader<Session> {
    @Override
    protected Identifier createIdentifier(Object entity) {
        return new HibernateEntityIdentifier(entity, (Session)this.getPersistenceContext());
    }

    protected String getPersistenceContextName() {
        return "hibernateSession";
    }

    @Override
    public void validate() {
        if (this.getPersistenceContext() == null) {
            throw new IllegalStateException("Unable to access a Seam Managed Hibernate Session. You must either have a Seam Managed Hibernate Session called hibernateSession or configure one in components.xml");
        }
    }

    public Session getSession() {
        return (Session)this.getPersistenceContext();
    }

    public void setSession(Session session) {
        this.setPersistenceContext(session);
    }
}

