/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;

public class DeleteSocialDocumentListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel document = ((DocumentEventContext)ctx).getSourceDocument();
        if (!SocialWorkspaceHelper.isSocialDocument(document)) {
            return;
        }
        if (!ctx.hasProperty("transition")) {
            return;
        }
        if (!"delete".equals(ctx.getProperty("transition"))) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument(document);
        DeleteSocialDocumentListener.cleanProxy(session, socialDocument);
    }

    public static void cleanProxy(CoreSession session, SocialDocument socialDocument) throws ClientException {
        DocumentModel publicProxy = socialDocument.getPublicDocument();
        if (publicProxy != null) {
            session.removeDocument(publicProxy.getRef());
        } else if (!"Article".equals(socialDocument.getType())) {
            session.removeDocument(socialDocument.getRestrictedDocument().getRef());
        }
    }
}

