/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.file.LRUFileCache;

public abstract class BinaryFileCache
extends LRUFileCache {
    protected static final String LEN_DIGEST_SUFFIX = "-len";

    public BinaryFileCache(File dir, long maxSize) {
        super(dir, maxSize);
    }

    public abstract boolean fetchFile(String var1, File var2);

    public abstract Long fetchLength(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long lengthFromCache(String key) {
        File f = super.getFile(key);
        if (f == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            String len = IOUtils.toString((InputStream)in);
            Long l = Long.valueOf(len);
            return l;
        }
        catch (Exception e) {
            LogFactory.getLog(BinaryFileCache.class).error((Object)("Cannot computle length of file " + f.getPath()), (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LogFactory.getLog(BinaryFileCache.class).error((Object)("Cannot close input file for " + f.getPath()), (Throwable)e);
                }
            }
        }
    }

    protected void putLengthInCache(String key, Long len) {
        OutputStream out = null;
        File tmp = null;
        try {
            tmp = this.getTempFile();
            out = new FileOutputStream(tmp);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(len.toString());
            ((Writer)writer).flush();
            out.close();
            out = null;
            this.putFile(key + LEN_DIGEST_SUFFIX, tmp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LogFactory.getLog(BinaryFileCache.class).error((Object)("Cannot close output stream for " + tmp.getPath()), (Throwable)e);
                }
            }
        }
    }

    public Long getLength(String key) {
        Long length = this.lengthFromCache(key);
        if (length != null) {
            return length;
        }
        return this.fetchLength(key);
    }

    public File getFile(String key) {
        File file = super.getFile(key);
        if (file != null) {
            return file;
        }
        File tmp = null;
        try {
            tmp = this.getTempFile();
            if (this.fetchFile(key, tmp)) {
                file = this.putFile(key, tmp);
                return file;
            }
        }
        catch (IOException e) {
            LogFactory.getLog(BinaryFileCache.class).error((Object)("IO error while fetching " + key + " on storage"), (Throwable)e);
        }
        if (tmp != null) {
            tmp.delete();
        }
        return null;
    }
}

