/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class FulltextUpdaterWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FulltextUpdaterWork.class);
    protected static final String CATEGORY = "fulltextUpdater";
    protected static final String TITLE = "Fulltext Updater";
    protected final String indexName;
    protected final boolean isSimpleText;
    protected final String text;
    protected final boolean isJob;

    public FulltextUpdaterWork(String repositoryName, String docId, String indexName, boolean isSimpleText, String text, boolean isJob) {
        this.setDocument(repositoryName, docId);
        this.indexName = indexName;
        this.isSimpleText = isSimpleText;
        this.text = text;
        this.isJob = isJob;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return TITLE;
    }

    public int getRetryCount() {
        return 1;
    }

    public void retryableWork() throws Exception {
        this.initSession();
        if (this.session.getPrincipal() == null) {
            return;
        }
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.setStatus("Updating");
        this.update();
        this.setStatus("Saving");
        this.session.save();
        this.setStatus("Done");
    }

    protected void update() throws ClientException {
        Object docs;
        if (this.isJob) {
            String query = String.format("SELECT * FROM Document WHERE ecm:fulltextJobId = '%s' AND ecm:isProxy = 0", this.docId);
            docs = this.session.query(query);
        } else {
            IdRef ref = new IdRef(this.docId);
            if (!this.session.exists((DocumentRef)ref)) {
                return;
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)ref);
            if (doc.isProxy()) {
                return;
            }
            docs = Collections.singleton(doc);
        }
        String fulltextPropertyName = this.getFulltextPropertyName();
        for (DocumentModel doc : docs) {
            try {
                DocumentRef ref = doc.getRef();
                if (this.isJob) {
                    this.session.setDocumentSystemProp(ref, "fulltextJobId", null);
                }
                this.session.setDocumentSystemProp(ref, fulltextPropertyName, (Serializable)((Object)this.text));
            }
            catch (DocumentException e) {
                log.error((Object)("Could not set fulltext on: " + doc.getId()), (Throwable)e);
            }
        }
    }

    protected String getFulltextPropertyName() {
        String name;
        String string = name = this.isSimpleText ? "simpleText" : "binaryText";
        if (!"default".equals(this.indexName)) {
            name = name + '_' + this.indexName;
        }
        return name;
    }
}

