/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.storage.sql.AbstractBinaryManager;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class LocalBinaryManager
extends AbstractBinaryManager {
    private static final Log log = LogFactory.getLog(LocalBinaryManager.class);
    public static final String DEFAULT_PATH = "binaries";
    public static final String DATA = "data";
    public static final String TMP = "tmp";
    public static final String CONFIG_FILE = "config.xml";
    protected File storageDir;
    protected File tmpDir;

    @Override
    public void initialize(RepositoryDescriptor repositoryDescriptor) throws IOException {
        File base;
        String path = repositoryDescriptor.binaryStorePath;
        if (path == null || path.trim().length() == 0) {
            path = DEFAULT_PATH;
        }
        path = Framework.expandVars((String)path);
        if ((path = path.trim()).startsWith("/") || path.startsWith("\\") || path.contains("://") || path.contains(":\\")) {
            base = new File(path);
        } else {
            File home = Environment.getDefault().getData();
            base = new File(home, path);
            File oldBase = new File(Framework.getRuntime().getHome().getPath(), path);
            if (oldBase.exists()) {
                log.warn((Object)("Old binaries path used (NXP-5370). Please move " + oldBase + " to " + base));
                base = oldBase;
            }
        }
        log.info((Object)("Repository '" + repositoryDescriptor.name + "' using " + (this.getClass().equals(LocalBinaryManager.class) ? "" : this.getClass().getSimpleName() + " and ") + "binary store: " + base));
        this.storageDir = new File(base, DATA);
        this.tmpDir = new File(base, TMP);
        this.storageDir.mkdirs();
        this.tmpDir.mkdirs();
        this.descriptor = this.getDescriptor(new File(base, CONFIG_FILE));
        this.createGarbageCollector();
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    @Override
    public Binary getBinary(InputStream in) throws IOException {
        String digest = this.storeAndDigest(in);
        File file = this.getFileForDigest(digest, false);
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest, this.repositoryName);
    }

    @Override
    public Binary getBinary(String digest) {
        File file = this.getFileForDigest(digest, false);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            log.warn((Object)("cannot fetch content at " + file.getPath() + " (file does not exist), check your configuration"));
            return null;
        }
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest, this.repositoryName);
    }

    public File getFileForDigest(String digest, boolean createDir) {
        int depth = this.descriptor.depth;
        if (digest.length() < 2 * depth) {
            return null;
        }
        StringBuilder buf = new StringBuilder(3 * depth - 1);
        for (int i = 0; i < depth; ++i) {
            if (i != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(digest.substring(2 * i, 2 * i + 2));
        }
        File dir = new File(this.storageDir, buf.toString());
        if (createDir) {
            dir.mkdirs();
        }
        return new File(dir, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeAndDigest(InputStream in) throws IOException {
        File tmp = File.createTempFile("create_", ".tmp", this.tmpDir);
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            String digest;
            try {
                digest = this.storeAndDigest(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
            File file = this.getFileForDigest(digest, true);
            this.atomicMove(tmp, file);
            String string = digest;
            return string;
        }
        finally {
            tmp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void atomicMove(File source, File dest) throws IOException {
        if (dest.exists()) {
            dest.setLastModified(source.lastModified());
            return;
        }
        if (!source.renameTo(dest)) {
            File tmp = File.createTempFile(dest.getName(), ".tmp", dest.getParentFile());
            try {
                FileInputStream in = null;
                OutputStream out = null;
                try {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(tmp);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                tmp.renameTo(dest);
            }
            finally {
                tmp.delete();
            }
            source.delete();
        }
        if (!dest.exists()) {
            throw new IOException("Could not create file: " + dest);
        }
    }

    protected void createGarbageCollector() {
        this.garbageCollector = new DefaultBinaryGarbageCollector(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touch(File file) {
        long time = System.currentTimeMillis();
        if (file.setLastModified(time)) {
            return;
        }
        if (!file.canWrite()) {
            return;
        }
        try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
            r.setLength(r.length());
        }
        catch (IOException e) {
            log.error((Object)("Cannot set last modified for file: " + file), (Throwable)e);
        }
    }

    public static class DefaultBinaryGarbageCollector
    implements BinaryGarbageCollector {
        public static int TIME_RESOLUTION = 2000;
        protected final LocalBinaryManager binaryManager;
        protected volatile long startTime;
        protected BinaryManagerStatus status;

        public DefaultBinaryGarbageCollector(LocalBinaryManager binaryManager) {
            this.binaryManager = binaryManager;
        }

        @Override
        public String getId() {
            return this.binaryManager.getStorageDir().toURI().toString();
        }

        @Override
        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        @Override
        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        @Override
        public void start() {
            if (this.startTime != 0L) {
                throw new RuntimeException("Alread started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
        }

        @Override
        public void mark(String digest) {
            File file = this.binaryManager.getFileForDigest(digest, false);
            if (!file.exists()) {
                log.error((Object)("Unknown file digest: " + digest));
                return;
            }
            LocalBinaryManager.touch(file);
        }

        @Override
        public void stop(boolean delete) {
            if (this.startTime == 0L) {
                throw new RuntimeException("Not started");
            }
            this.deleteOld(this.binaryManager.getStorageDir(), this.startTime - (long)TIME_RESOLUTION, 0, delete);
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }

        protected void deleteOld(File file, long minTime, int depth, boolean delete) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.deleteOld(f, minTime, depth + 1, delete);
                }
                if (depth > 0 && file.list().length == 0) {
                    file.delete();
                }
            } else if (file.isFile() && file.canWrite()) {
                long lastModified = file.lastModified();
                long length = file.length();
                if (lastModified == 0L) {
                    log.error((Object)("Cannot read last modified for file: " + file));
                } else if (lastModified < minTime) {
                    this.status.sizeBinariesGC += length;
                    ++this.status.numBinariesGC;
                    if (delete && !file.delete()) {
                        log.warn((Object)("Cannot gc file: " + file));
                    }
                } else {
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                }
            }
        }
    }
}

