/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.schema.types.Type;

public abstract class SQLBaseProperty
implements Property {
    protected final Type type;
    protected final boolean readonly;
    public static final String DC_ISSUED = "dc:issued";
    public static final String RELATED_TEXT_RESOURCES = "relatedtextresources";
    protected static final Set<String> VERSION_WRITABLE_PROPS = new HashSet<String>(Arrays.asList("ecm:fulltextJobId", "ecm:binaryText", "ecm:lifeCycleState", "ecm:lockOwner", "ecm:lockCreated", "dc:issued", "relatedtextresources"));

    public static boolean isSpecialSystemProperty(String name) {
        if (name == null) {
            return false;
        }
        return VERSION_WRITABLE_PROPS.contains(name) || name.startsWith("ecm:binaryText") || name.startsWith("ecm:simpleText");
    }

    public SQLBaseProperty(Type type, String name, boolean readonly) {
        this.type = type;
        this.readonly = SQLBaseProperty.isSpecialSystemProperty(name) ? false : readonly;
    }

    public void checkWritable() throws DocumentException {
        if (this.readonly) {
            throw new DocumentException("Cannot write property: " + this.getName());
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        throw new UnsupportedOperationException();
    }

    public void setNull() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public boolean isPropertySet(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Iterator<Property> getPropertyIterator() throws DocumentException {
        throw new UnsupportedOperationException();
    }
}

