/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.ConnectionHelper;

public class DialectOracle
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectOracle.class);
    protected final String fulltextParameters;
    protected boolean pathOptimizationsEnabled;
    protected int pathOptimizationsVersion = 0;
    private static final String DEFAULT_USERS_SEPARATOR = "|";
    protected String usersSeparator;
    protected XAErrorLogger xaErrorLogger;
    protected static Set<Character> CHARS_RESERVED = Collections.singleton(Character.valueOf('%'));
    private static boolean initialized;
    private static Constructor<?> arrayDescriptorConstructor;
    private static Constructor<?> arrayConstructor;

    public DialectOracle(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        this.fulltextParameters = repositoryDescriptor == null ? null : (repositoryDescriptor.fulltextAnalyzer == null ? "" : repositoryDescriptor.fulltextAnalyzer);
        boolean bl = this.pathOptimizationsEnabled = repositoryDescriptor == null ? false : repositoryDescriptor.pathOptimizationsEnabled;
        if (this.pathOptimizationsEnabled) {
            int n = this.pathOptimizationsVersion = repositoryDescriptor == null ? 0 : repositoryDescriptor.pathOptimizationsVersion;
        }
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        this.xaErrorLogger = this.newXAErrorLogger();
    }

    protected XAErrorLogger newXAErrorLogger() throws StorageException {
        try {
            return new XAErrorLogger();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Cannot initialize xa error loggger", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new StorageException("Cannot introspect oracle driver classes", e);
        }
    }

    @Override
    public String getConnectionSchema(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
        log.trace((Object)("SQL: " + sql));
        ResultSet rs = st.executeQuery(sql);
        rs.next();
        String user = rs.getString(1);
        log.trace((Object)("SQL:   -> " + user));
        st.close();
        return user;
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectOracle.jdbcInfo("NVARCHAR2(2000)", 12);
                }
                if (type.isClob() || type.length > 2000) {
                    return DialectOracle.jdbcInfo("NCLOB", 2005);
                }
                return DialectOracle.jdbcInfo("NVARCHAR2(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectOracle.jdbcInfo("NUMBER(1,0)", -7);
            }
            case LONG: {
                return DialectOracle.jdbcInfo("NUMBER(19,0)", -5);
            }
            case DOUBLE: {
                return DialectOracle.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return DialectOracle.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectOracle.jdbcInfo("VARCHAR2(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectOracle.jdbcInfo("VARCHAR2(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectOracle.jdbcInfo("VARCHAR2(250)", 12);
            }
            case TINYINT: {
                return DialectOracle.jdbcInfo("NUMBER(3,0)", -6);
            }
            case INTEGER: {
                return DialectOracle.jdbcInfo("NUMBER(10,0)", 4);
            }
            case AUTOINC: {
                return DialectOracle.jdbcInfo("NUMBER(10,0)", 4);
            }
            case FTINDEXED: {
                return DialectOracle.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return DialectOracle.jdbcInfo("NCLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectOracle.jdbcInfo("VARCHAR(25)", 12);
            }
            case CLUSTERFRAGS: {
                return DialectOracle.jdbcInfo("VARCHAR2(4000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 8 && actual == 6) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NVARCHAR2")) {
            return true;
        }
        if (expected == 2005 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        if (expected == -7 && actual == 3 && actualName.equals("NUMBER") && actualSize == 1) {
            return true;
        }
        if (expected == -6 && actual == 3 && actualName.equals("NUMBER") && actualSize == 3) {
            return true;
        }
        if (expected == 4 && actual == 3 && actualName.equals("NUMBER") && actualSize == 10) {
            return true;
        }
        if (expected == -5 && actual == 3 && actualName.equals("NUMBER") && actualSize == 19) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        return expected == 2005 && actual == 1111 && actualName.equals("NVARCHAR2");
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 2005: {
                Reader r = rs.getCharacterStream(index);
                if (r == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                try {
                    int n;
                    char[] buffer = new char[4096];
                    while ((n = r.read(buffer)) != -1) {
                        sb.append(new String(buffer, 0, n));
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read CLOB", (Throwable)e);
                }
                return sb.toString();
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 30;
    }

    @Override
    protected int getMaxIndexNameSize() {
        return 25;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s(%s) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('%s SYNC (ON COMMIT) TRANSACTIONAL')", quotedIndexName, table.getQuotedName(), columns.get(0).getQuotedName(), this.fulltextParameters);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        Dialect.FulltextQuery ft = this.analyzeFulltextQuery(query = query.replace("*", "%"));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return DialectOracle.translateFulltext(ft, "OR", "AND", "NOT", "{", "}", CHARS_RESERVED, "", "", true);
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext" + indexSuffix);
        String score = String.format("SCORE(%d)", nthMatch);
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        if (nthMatch == 1) {
            info.joins = Collections.singletonList(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.whereExpr = String.format("CONTAINS(%s, ?, %d) > 0", ftColumn.getFullQuotedName(), nthMatch);
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = String.format("(%s / 100)", score);
        info.scoreAlias = this.openQuote() + "_nxscore" + nthSuffix + this.closeQuote();
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public boolean supportsUpdateFrom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public boolean needsOracleJoins() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS NVARCHAR2(%d))";
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT COLUMN_VALUE FROM TABLE(nx_get_read_acls_for(?)))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "{CALL nx_update_read_acls}";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "{CALL nx_rebuild_read_acls}";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        if (this.pathOptimizationsVersion == 2) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND ancestor = ?)", idColumnName);
        }
        if (this.pathOptimizationsVersion == 1) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND ? MEMBER OF ancestors)", idColumnName);
        }
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterNodeIdSql() {
        return "SELECT SYS_CONTEXT('USERENV', 'SID') || ',' || SERIAL# FROM GV$SESSION WHERE SID = SYS_CONTEXT('USERENV', 'SID') AND INST_ID = SYS_CONTEXT('USERENV', 'INSTANCE')";
    }

    @Override
    public boolean isClusteringDeleteNeeded() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "{CALL NX_CLUSTER_INVAL(?, ?, ?, '%s')}";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT id, fragments, kind FROM cluster_invals WHERE nodeid = '%s'";
    }

    @Override
    public String getClusterDeleteInvalidations() {
        return "DELETE FROM cluster_invals WHERE nodeid = '%s'";
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return String.format("SELECT * FROM (SELECT /*+ FIRST_ROWS(%d) */  a.*, ROWNUM rnum FROM (%s) a WHERE ROWNUM <= %d) WHERE rnum  > %d", limit, sql, limit + offset, offset);
    }

    @Override
    public boolean supportsWith() {
        return false;
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public boolean supportsArraysReturnInsteadOfRows() {
        return true;
    }

    @Override
    public boolean hasNullEmptyString() {
        return true;
    }

    private static void init() throws SQLException {
        if (!initialized) {
            try {
                Class<?> arrayDescriptorClass = Class.forName("oracle.sql.ArrayDescriptor");
                arrayDescriptorConstructor = arrayDescriptorClass.getConstructor(String.class, Connection.class);
                Class<?> arrayClass = Class.forName("oracle.sql.ARRAY");
                arrayConstructor = arrayClass.getConstructor(arrayDescriptorClass, Connection.class, Object.class);
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
            initialized = true;
        }
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        if (elements == null || elements.length == 0) {
            return null;
        }
        DialectOracle.init();
        try {
            connection = ConnectionHelper.unwrap((Connection)connection);
            Object arrayDescriptor = arrayDescriptorConstructor.newInstance("NX_STRING_TABLE", connection);
            return (Array)arrayConstructor.newInstance(arrayDescriptor, connection, elements);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/oracle.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/oracle.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR2(36)"));
        properties.put("argIdType", (Serializable)((Object)"VARCHAR2"));
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        properties.put("pathOptimizationsVersion1", Boolean.valueOf(this.pathOptimizationsVersion == 1));
        properties.put("pathOptimizationsVersion2", Boolean.valueOf(this.pathOptimizationsVersion == 2));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        properties.put("proxiesEnabled", Boolean.valueOf(this.proxiesEnabled));
        properties.put("softDeleteEnabled", Boolean.valueOf(this.softDeleteEnabled));
        if (!this.fulltextDisabled) {
            Table ft = database.getTable("fulltext");
            properties.put("fulltextTable", (Serializable)((Object)ft.getQuotedName()));
            ModelFulltext fti = model.getFulltextInfo();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  :NEW.%s := :NEW.%s || ' ' || :NEW.%s; ", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            properties.put("fulltextTriggerStatements", (Serializable)((Object)StringUtils.join(lines, (String)"\n")));
        }
        String[] permissions = NXCore.getSecurityService().getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add(String.format("  INTO ACLR_PERMISSION VALUES ('%s')", perm));
        }
        properties.put("readPermissions", (Serializable)((Object)StringUtils.join(permsList, (String)"\n")));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        properties.put("everyone", (Serializable)((Object)"Everyone"));
        return properties;
    }

    protected int getOracleErrorCode(Throwable t) {
        try {
            int errorCode;
            Method m = t.getClass().getMethod("getOracleError", new Class[0]);
            Integer oracleError = (Integer)m.invoke((Object)t, new Object[0]);
            if (oracleError != null && (errorCode = oracleError.intValue()) != 0) {
                return errorCode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t instanceof SQLException) {
            return ((SQLException)t).getErrorCode();
        }
        return 0;
    }

    @Override
    public boolean isConnectionClosedException(Throwable t) {
        if (t instanceof XAException) {
            try {
                this.xaErrorLogger.log((XAException)t);
            }
            catch (Exception e) {
                log.error((Object)"Cannot introspect oracle error ", t);
            }
            return false;
        }
        if (this.isSocketError(t)) {
            return true;
        }
        if (t instanceof SQLException) {
            return this.isConnectionClosed(((SQLException)t).getErrorCode());
        }
        log.warn((Object)("Unknown exception type " + t.getClass()), t);
        return false;
    }

    public boolean isSocketError(Throwable t) {
        if (t instanceof SocketException) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause == null || cause == t) {
            return false;
        }
        return this.isSocketError(cause);
    }

    protected boolean isConnectionClosed(int oracleError) {
        switch (oracleError) {
            case 28: 
            case 1033: 
            case 1034: 
            case 1041: 
            case 1089: 
            case 1090: 
            case 3113: 
            case 3114: 
            case 12571: 
            case 17002: 
            case 17008: 
            case 17410: 
            case 24768: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        switch (this.getOracleErrorCode(t)) {
            case 60: 
            case 2291: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValidationQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getBlobLengthFunction() {
        return "LENGTHB";
    }

    @Override
    public List<String> getPostCreateIdentityColumnSql(Column column) {
        String table = column.getTable().getPhysicalName();
        String col = column.getPhysicalName();
        String seq = table + "_IDSEQ";
        String trig = table + "_IDTRIG";
        String createSeq = String.format("CREATE SEQUENCE \"%s\"", seq);
        String createTrig = String.format("CREATE TRIGGER \"%s\"\n  BEFORE INSERT ON \"%s\"\n  FOR EACH ROW WHEN (NEW.\"%s\" IS NULL)\nBEGIN\n  SELECT \"%s\".NEXTVAL INTO :NEW.\"%s\" FROM DUAL;\nEND;", trig, table, col, seq, col);
        return Arrays.asList(createSeq, createTrig);
    }

    @Override
    public boolean hasIdentityGeneratedKey() {
        return false;
    }

    @Override
    public String getIdentityGeneratedKeySql(Column column) {
        String table = column.getTable().getPhysicalName();
        String seq = table + "_IDSEQ";
        return String.format("SELECT \"%s\".CURRVAL FROM DUAL", seq);
    }

    @Override
    public String getAncestorsIdsSql() {
        return "SELECT NX_ANCESTORS(?) FROM DUAL";
    }

    @Override
    public String getDescending() {
        return " DESC NULLS LAST";
    }

    @Override
    public String getDateCast() {
        return "TRUNC(%s)";
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public String getSoftDeleteSql() {
        return "{CALL NX_DELETE(?, ?)}";
    }

    @Override
    public String getSoftDeleteCleanupSql() {
        return "{CALL NX_DELETE_PURGE(?, ?, ?)}";
    }

    protected static class XAErrorLogger {
        protected final Class<?> oracleXAExceptionClass = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.xa.OracleXAException");
        protected final Method m_xaError = this.oracleXAExceptionClass.getMethod("getXAError", new Class[0]);
        protected final Method m_xaErrorMessage = this.oracleXAExceptionClass.getMethod("getXAErrorMessage", this.m_xaError.getReturnType());
        protected final Method m_oracleError = this.oracleXAExceptionClass.getMethod("getOracleError", new Class[0]);
        protected final Method m_oracleSQLError = this.oracleXAExceptionClass.getMethod("getOracleSQLError", new Class[0]);

        public void log(XAException e) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            int xaError = (Integer)this.m_xaError.invoke((Object)e, new Object[0]);
            String xaErrorMessage = (String)this.m_xaErrorMessage.invoke((Object)xaError, new Object[0]);
            int oracleError = (Integer)this.m_oracleError.invoke((Object)e, new Object[0]);
            int oracleSQLError = (Integer)this.m_oracleSQLError.invoke((Object)e, new Object[0]);
            StringBuilder builder = new StringBuilder();
            builder.append("Oracle XA Error : " + xaError + " (" + xaErrorMessage + "),");
            builder.append("Oracle Error : " + oracleError + ",");
            builder.append("Oracle SQL Error : " + oracleSQLError);
            log.warn((Object)builder.toString(), (Throwable)e);
        }
    }
}

