/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.ExitCode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLauncher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String COMMENT_PREFIX = "c ";
    protected long beginTime;
    protected ExitCode exitCode = ExitCode.UNKNOWN;
    protected Reader reader;
    protected transient PrintWriter out = new PrintWriter(System.out, true);
    protected transient Thread shutdownHook = new Thread(){

        public void run() {
            AbstractLauncher.this.displayResult();
        }
    };
    protected ISolver solver;
    private boolean silent = false;

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void displayResult() {
        if (this.solver != null) {
            System.out.flush();
            this.out.flush();
            double wallclocktime = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
            this.solver.printStat(this.out, COMMENT_PREFIX);
            this.solver.printInfos(this.out, COMMENT_PREFIX);
            this.out.println(new StringBuffer(ANSWER_PREFIX).append(this.exitCode).toString());
            if (this.exitCode == ExitCode.SATISFIABLE) {
                int[] model = this.solver.model();
                this.out.print(SOLUTION_PREFIX);
                this.reader.decode(model, this.out);
                this.out.println();
            }
            this.log(new StringBuffer("Total wall clock time (in seconds) : ").append(wallclocktime).toString());
        }
    }

    public abstract void usage();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void displayHeader() {
        block14: {
            this.displayLicense();
            try {
                v0 = Class.forName("org.sat4j.AbstractLauncher");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            url = v0.getResource("/sat4j.version");
            if (url == null) {
                this.log("no version file found!!!");
            } else {
                in = null;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(url.openStream()));
                        this.log(new StringBuffer("version ").append(in.readLine()).toString());
                    }
                    catch (IOException e) {
                        this.log(new StringBuffer("c ERROR: ").append(e.getMessage()).toString());
                    }
                }
                catch (Throwable var5_5) {
                    var4_7 = null;
                    if (in == null) throw var5_5;
                    try {
                        in.close();
                        throw var5_5;
                    }
                    catch (IOException e) {
                        this.log(new StringBuffer("c ERROR: ").append(e.getMessage()).toString());
                    }
                    throw var5_5;
                }
                {
                    var4_8 = null;
                    if (in == null) break block14;
                }
                ** try [egrp 3[TRYBLOCK] [4 : 131->138)] { 
lbl33:
                // 1 sources

                in.close();
            }
            break block14;
lbl35:
            // 1 sources

            catch (IOException e) {
                this.log(new StringBuffer("c ERROR: ").append(e.getMessage()).toString());
            }
        }
        prop = System.getProperties();
        infoskeys = new String[]{"java.runtime.name", "java.vm.name", "java.vm.version", "java.vm.vendor", "sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        i = 0;
        while (true) {
            if (i >= infoskeys.length) {
                runtime = Runtime.getRuntime();
                this.log(new StringBuffer("Free memory \t\t").append(runtime.freeMemory()).toString());
                this.log(new StringBuffer("Max memory \t\t").append(runtime.maxMemory()).toString());
                this.log(new StringBuffer("Total memory \t\t").append(runtime.totalMemory()).toString());
                this.log(new StringBuffer("Number of processors \t").append(runtime.availableProcessors()).toString());
                return;
            }
            key = infoskeys[i];
            this.log(new StringBuffer(String.valueOf(key)).append(key.length() < 14 ? "\t\t" : "\t").append(prop.getProperty(key)).toString());
            ++i;
        }
    }

    public void displayLicense() {
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2010 Daniel Le Berre");
        this.log("This is free software under the dual EPL/GNU LGPL licenses.");
        this.log("See www.sat4j.org for details.");
    }

    protected IProblem readProblem(String problemname) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        this.log(new StringBuffer("solving ").append(problemname).toString());
        this.log("reading problem ... ");
        this.reader = this.createReader(this.solver, problemname);
        IProblem problem = this.reader.parseInstance(problemname);
        this.log(new StringBuffer("... done. Wall clock time ").append((double)(System.currentTimeMillis() - this.beginTime) / 1000.0).append("s.").toString());
        this.log(new StringBuffer("declared #vars     ").append(problem.nVars()).toString());
        if (this.solver.nVars() < this.solver.realNumberOfVariables()) {
            this.log(new StringBuffer("internal #vars     ").append(this.solver.realNumberOfVariables()).toString());
        }
        this.log(new StringBuffer("#constraints  ").append(problem.nConstraints()).toString());
        problem.printInfos(this.out, COMMENT_PREFIX);
        return problem;
    }

    protected abstract Reader createReader(ISolver var1, String var2);

    public void run(String[] args) {
        try {
            String instanceName;
            this.displayHeader();
            this.solver = this.configureSolver(args);
            if (this.solver == null) {
                this.usage();
                return;
            }
            if (!this.silent) {
                this.solver.setVerbose(true);
            }
            if ((instanceName = this.getInstanceName(args)) == null) {
                this.usage();
                return;
            }
            this.beginTime = System.currentTimeMillis();
            this.readProblem(instanceName);
            try {
                this.solve(this.solver);
            }
            catch (TimeoutException timeoutException) {
                this.log("timeout");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(new StringBuffer("FATAL ").append(e.getLocalizedMessage()).toString());
        }
        catch (IOException e) {
            System.err.println(new StringBuffer("FATAL ").append(e.getLocalizedMessage()).toString());
        }
        catch (ContradictionException contradictionException) {
            this.exitCode = ExitCode.UNSATISFIABLE;
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException e) {
            System.err.println(new StringBuffer("FATAL ").append(e.getLocalizedMessage()).toString());
        }
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    public void log(String message) {
        if (!this.silent) {
            this.out.println(new StringBuffer(COMMENT_PREFIX).append(message).toString());
        }
    }

    protected void solve(IProblem problem) throws TimeoutException {
        this.exitCode = problem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
    }

    public final void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ExitCode getExitCode() {
        return this.exitCode;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    protected void setSilent(boolean b) {
        this.silent = b;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.out = new PrintWriter(System.out, true);
        this.shutdownHook = new Thread(){

            public void run() {
                AbstractLauncher.this.displayResult();
            }
        };
    }

    protected <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> afactory) {
        if (afactory != null) {
            this.log("Available solvers: ");
            String[] names = afactory.solverNames();
            int i = 0;
            while (i < names.length) {
                this.log(names[i]);
                ++i;
            }
        }
    }
}

