/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public final class TaskEventNotificationHelper {
    public static void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, Task task, String eventId, Map<String, Serializable> properties, String comment, String category) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        EventContextImpl eventContext = null;
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        properties.put("comment", (Serializable)((Object)comment));
        properties.put("category", (Serializable)((Object)category));
        properties.put("taskInstance", (Serializable)task);
        String disableNotif = task.getVariable("disableNotificationService");
        if (disableNotif != null && Boolean.TRUE.equals(Boolean.valueOf(disableNotif))) {
            properties.put("disableNotificationService", Boolean.TRUE);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        TaskEventNotificationHelper.getEventProducer().fireEvent(event);
    }

    public static EventProducer getEventProducer() {
        return (EventProducer)Framework.getLocalService(EventProducer.class);
    }
}

