/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.runtime.metrics.MetricsService;

public abstract class AbstractDirectory
implements Directory {
    protected final Log log = LogFactory.getLog(AbstractDirectory.class);
    public final String name;
    protected DirectoryFieldMapper fieldMapper;
    protected final Map<String, Reference> references = new HashMap<String, Reference>();
    protected final DirectoryCache cache;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected Set<Session> sessions = new HashSet<Session>();
    protected final Counter sessionCount;
    protected final Counter sessionMaxCount;

    protected AbstractDirectory(String name) {
        this.name = name;
        this.cache = new DirectoryCache(name);
        this.sessionCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "sessions", "active"}));
        this.sessionMaxCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "sessions", "max"}));
    }

    public void invalidateCaches() throws DirectoryException {
        this.cache.invalidateAll();
        for (Reference ref : this.references.values()) {
            Directory targetDir = ref.getTargetDirectory();
            if (targetDir == null) continue;
            targetDir.invalidateDirectoryCache();
        }
    }

    public DirectoryFieldMapper getFieldMapper() {
        if (this.fieldMapper == null) {
            this.fieldMapper = new DirectoryFieldMapper();
        }
        return this.fieldMapper;
    }

    public Reference getReference(String referenceFieldName) {
        return this.references.get(referenceFieldName);
    }

    public boolean isReference(String referenceFieldName) {
        return this.references.containsKey(referenceFieldName);
    }

    public void addReference(Reference reference) throws ClientException {
        reference.setSourceDirectoryName(this.getName());
        this.references.put(reference.getFieldName(), reference);
    }

    public void addReferences(Reference[] references) throws ClientException {
        for (Reference reference : references) {
            this.addReference(reference);
        }
    }

    public Collection<Reference> getReferences() {
        return this.references.values();
    }

    public void orderEntries(List<DocumentModel> entries, Map<String, String> orderBy) throws DirectoryException {
        Collections.sort(entries, new DocumentModelComparator(this.getSchema(), orderBy));
    }

    public DirectoryCache getCache() {
        return this.cache;
    }

    public synchronized void removeSession(Session session) {
        if (this.sessions.remove(session)) {
            this.sessionCount.dec();
        }
    }

    public synchronized void addSession(Session session) {
        this.sessions.add(session);
        this.sessionCount.inc();
        if (this.sessionCount.getCount() > this.sessionMaxCount.getCount()) {
            this.sessionMaxCount.inc();
        }
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
    }

    public boolean isMultiTenant() {
        return false;
    }

    public synchronized void shutdown() {
        Set<Session> lastSessions = this.sessions;
        this.sessions = new HashSet<Session>();
        this.sessionCount.dec(this.sessionCount.getCount());
        this.sessionMaxCount.dec(this.sessionMaxCount.getCount());
        for (Session session : lastSessions) {
            try {
                session.close();
            }
            catch (DirectoryException e) {
                this.log.error((Object)("Error during shutdown of directory '" + this.name + "'"), (Throwable)e);
            }
        }
    }
}

