/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.UpdateEntries", category="Services", label="Updates directory entries", description="Updates directory entries. Entries to update are sent as a JSON array. Returns the updated entries ids as a JSON array of JSON objects containing all fields", addToStudio=false)
public class UpdateDirectoryEntries
extends AbstractDirectoryOperation {
    public static final String ID = "Directory.UpdateEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="entries", required=true)
    protected String jsonEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws Exception {
        this.validateCanManageDirectories(this.ctx);
        ObjectMapper mapper = new ObjectMapper();
        List entries = (List)mapper.readValue(this.jsonEntries, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        ArrayList<String> ids = new ArrayList<String>();
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        String idField = directory.getIdField();
        try (Session session = null;){
            session = this.directoryService.open(this.directoryName);
            for (Map entry : entries) {
                DocumentModel doc;
                if (!entry.containsKey(idField) || (doc = session.getEntry((String)entry.get(idField))) == null) continue;
                doc.getDataModel(directory.getSchema()).setMap(entry);
                session.updateEntry(doc);
                ids.add(doc.getId());
            }
        }
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, ids);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }
}

