/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.IODocumentManager;
import org.nuxeo.ecm.core.io.exceptions.ExportDocumentException;
import org.nuxeo.ecm.core.io.exceptions.ImportDocumentException;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentsListReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.runtime.api.Framework;

public class IODocumentManagerImpl
implements IODocumentManager {
    private static final long serialVersionUID = -3131999198524020179L;
    private static final Log log = LogFactory.getLog(IODocumentManagerImpl.class);

    private static CoreSession getCoreSession(String repo) throws ClientException {
        CoreSession systemSession;
        try {
            Framework.login();
            RepositoryManager manager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repository = manager.getRepository(repo);
            if (repository == null) {
                log.error((Object)("repository " + repo + " not in available repos: " + manager.getRepositories()));
                throw new ClientException("cannot get repository: " + repo);
            }
            systemSession = repository.open();
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to open core session to repository " + repo, (Throwable)e);
        }
        return systemSession;
    }

    @Override
    public DocumentTranslationMap importDocuments(InputStream in, String repo, DocumentRef root) throws ImportDocumentException, ClientException {
        CoreSession coreSession = IODocumentManagerImpl.getCoreSession(repo);
        DocumentModel dst = coreSession.getDocument(root);
        NuxeoArchiveReader reader = null;
        AbstractDocumentModelWriter writer = null;
        try {
            reader = new NuxeoArchiveReader(in);
            writer = new DocumentModelWriter(coreSession, dst.getPathAsString());
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader(reader);
            pipe.setWriter(writer);
            DocumentTranslationMap documentTranslationMap = pipe.run();
            return documentTranslationMap;
        }
        catch (Exception e) {
            throw new ImportDocumentException(e);
        }
        finally {
            coreSession.save();
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public DocumentTranslationMap importDocuments(InputStream in, DocumentWriter customDocWriter) throws ImportDocumentException {
        try (NuxeoArchiveReader reader = null;){
            reader = new NuxeoArchiveReader(in);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader(reader);
            pipe.setWriter(customDocWriter);
            DocumentTranslationMap map = pipe.run();
            customDocWriter.close();
            DocumentTranslationMap documentTranslationMap = map;
            return documentTranslationMap;
        }
    }

    @Override
    public DocumentTranslationMap exportDocuments(OutputStream out, String repo, Collection<DocumentRef> sources, boolean recurse, String format) throws ExportDocumentException, ClientException {
        CoreSession coreSession = IODocumentManagerImpl.getCoreSession(repo);
        DocumentReader reader = null;
        DocumentWriter writer = null;
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            writer = new NuxeoArchiveWriter(out);
            pipe.setWriter(writer);
            if (!recurse) {
                reader = DocumentsListReader.createDocumentsListReader(coreSession, sources);
                pipe.setReader(reader);
                DocumentTranslationMap documentTranslationMap = pipe.run();
                return documentTranslationMap;
            }
            ArrayList<DocumentTranslationMap> maps = new ArrayList<DocumentTranslationMap>();
            for (DocumentRef rootSource : sources) {
                reader = new DocumentTreeReader(coreSession, rootSource);
                pipe.setReader(reader);
                DocumentTranslationMap map = pipe.run();
                if (map == null) continue;
                maps.add(map);
            }
            DocumentTranslationMap documentTranslationMap = DocumentTranslationMapImpl.merge(maps);
            return documentTranslationMap;
        }
        catch (Exception e) {
            throw new ExportDocumentException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public DocumentTranslationMap exportDocuments(OutputStream out, DocumentReader customDocReader, String format) throws ExportDocumentException {
        try (DocumentWriter writer = null;){
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            writer = new NuxeoArchiveWriter(out);
            pipe.setWriter(writer);
            pipe.setReader(customDocReader);
            ArrayList<DocumentTranslationMap> maps = new ArrayList<DocumentTranslationMap>();
            DocumentTranslationMap map = pipe.run();
            if (map != null) {
                maps.add(map);
            }
            DocumentTranslationMap documentTranslationMap = DocumentTranslationMapImpl.merge(maps);
            return documentTranslationMap;
        }
    }

    @Override
    public DocumentTranslationMap importDocuments(DocumentReader customDocReader, DocumentWriter customDocWriter) throws ImportDocumentException {
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader(customDocReader);
            pipe.setWriter(customDocWriter);
            DocumentTranslationMap map = pipe.run();
            return map;
        }
        catch (Exception e) {
            throw new ImportDocumentException(e);
        }
    }
}

