/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListDiff
implements Serializable {
    public static final int ADD = 1;
    public static final int INSERT = 2;
    public static final int REMOVE = 3;
    public static final int MODIFY = 4;
    public static final int MOVE = 5;
    public static final int CLEAR = 6;
    private static final long serialVersionUID = 2239608903749525011L;
    final List<Entry> diff = new ArrayList<Entry>();

    public ListDiff() {
    }

    public ListDiff(ListDiff listDiff) {
        if (listDiff != null) {
            this.diff.addAll(Arrays.asList(listDiff.diff()));
        }
    }

    public void add(Object value) {
        this.diff.add(new Entry(1, 0, value));
    }

    public void insert(int index, Object value) {
        this.diff.add(new Entry(2, index, value));
    }

    public void modify(int index, Object value) {
        this.diff.add(new Entry(4, index, value));
    }

    public void move(int fromIndex, int toIndex) {
        this.diff.add(new Entry(5, fromIndex, toIndex));
    }

    public void remove(int index) {
        this.diff.add(new Entry(3, index, null));
    }

    public void removeAll() {
        this.diff.add(new Entry(6, 0, null));
    }

    public void reset() {
        this.diff.clear();
    }

    public boolean isDirty() {
        return !this.diff.isEmpty();
    }

    public Entry[] diff() {
        return this.diff.toArray(new Entry[this.diff.size()]);
    }

    public String toString() {
        return String.format("ListDiff { %s }", this.diff.toString());
    }

    public static String typeToString(int type) {
        if (type == 1) {
            return "ADD";
        }
        if (type == 2) {
            return "INSERT";
        }
        if (type == 3) {
            return "REMOVE";
        }
        if (type == 4) {
            return "MODIFY";
        }
        if (type == 5) {
            return "MOVE";
        }
        if (type == 6) {
            return "CLEAR";
        }
        return "invalid type: " + Integer.toString(type);
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = -3261465349877937657L;
        public int index;
        public int type;
        public Object value;

        public Entry() {
        }

        public Entry(int type, int index, Object value) {
            this.index = index;
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return String.format("Entry {%s, %s, %s}", this.index, ListDiff.typeToString(this.type), this.value);
        }
    }
}

