/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;
import org.nuxeo.runtime.api.Framework;

public class FileBlob
extends DefaultStreamBlob
implements Serializable {
    private static final long serialVersionUID = 373720300515677319L;
    protected transient File file;

    public FileBlob(File file) {
        this(file, null, null);
    }

    public FileBlob(File file, String ctype) {
        this(file, ctype, null);
    }

    public FileBlob(File file, String mimeType, String encoding) {
        this(file, mimeType, encoding, null, null);
    }

    public FileBlob(File file, String mimeType, String encoding, String filename, String digest) {
        this.file = file;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.digest = digest;
        this.filename = filename != null ? filename : (file != null ? file.getName() : null);
    }

    public FileBlob(InputStream in) throws IOException {
        this(in, null, null);
    }

    public FileBlob(InputStream in, String ctype) throws IOException {
        this(in, ctype, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBlob(InputStream in, String mimeType, String encoding) throws IOException {
        this.mimeType = mimeType;
        this.encoding = encoding;
        FileOutputStream out = null;
        try {
            this.file = File.createTempFile("NXCore-FileBlob-", ".tmp");
            this.file.deleteOnExit();
            out = new FileOutputStream(this.file);
            FileBlob.copy(in, out);
            Framework.trackFile((File)this.file, (Object)this);
        }
        catch (Throwable throwable) {
            FileUtils.close((InputStream)in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
        FileUtils.close((OutputStream)out);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getLength() {
        return this.file == null ? 0L : this.file.length();
    }

    @Override
    public InputStream getStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public Blob persist() {
        return this;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.file = File.createTempFile("NXCore-FileBlob-", ".tmp");
        this.file.deleteOnExit();
        Framework.trackFile((File)this.file, (Object)this);
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(this.file);
            byte[] buffer = new byte[65536];
            int bytes = in.readInt();
            while (bytes > -1 && (read = in.read(buffer, 0, bytes)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                if ((bytes -= read) != 0) continue;
                bytes = in.readInt();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        InputStream in = null;
        try {
            in = this.getStream();
            int read = 0;
            byte[] buf = new byte[65536];
            while ((read = in.read(buf)) != -1) {
                out.writeInt(read);
                out.write(buf, 0, read);
            }
            out.writeInt(-1);
        }
        finally {
            FileUtils.close((InputStream)in);
        }
    }
}

