/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.management;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.storage.sql.management.RepositoryStatusMBean;

public class RepositoryStatus
implements RepositoryStatusMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RepositoryManagement> getRepositories() throws NamingException {
        InitialContext context;
        LinkedList<RepositoryManagement> list = new LinkedList<RepositoryManagement>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(RepositoryStatus.class.getClassLoader());
        try {
            context = new InitialContext();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        for (String prefix : new String[]{"java:NXRepository", "NXRepository"}) {
            NamingEnumeration<Binding> bindings;
            try {
                bindings = context.listBindings(prefix);
            }
            catch (NamingException e) {
                continue;
            }
            try (NamingEnumeration<Binding> e = null;){
                e = bindings;
                while (e.hasMore()) {
                    Object object;
                    Binding binding = (Binding)e.nextElement();
                    String name = binding.getName();
                    if (binding.isRelative()) {
                        name = prefix + '/' + name;
                    }
                    if (!((object = context.lookup(name)) instanceof RepositoryManagement)) continue;
                    list.add((RepositoryManagement)object);
                }
            }
        }
        if (list.size() == 0) {
            List repos = RepositoryResolver.getRepositories();
            for (Repository repo : repos) {
                list.add((RepositoryManagement)repo);
            }
        }
        return list;
    }

    @Override
    public String listActiveSessions() {
        List<RepositoryManagement> repositories = this.repositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Actives sessions for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.getActiveSessionsCount());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public int getActiveSessionsCount() {
        List<RepositoryManagement> repositories = this.repositories();
        int count = 0;
        for (RepositoryManagement repository : repositories) {
            count += repository.getActiveSessionsCount();
        }
        return count;
    }

    @Override
    public String clearCaches() {
        List<RepositoryManagement> repositories = this.repositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Cleared cached objects for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.clearCaches());
            buf.append("<br />");
        }
        return buf.toString();
    }

    protected List<RepositoryManagement> repositories() {
        try {
            return this.getRepositories();
        }
        catch (NamingException e) {
            throw new UnsupportedOperationException("Cannot fetch repositories", e);
        }
    }

    @Override
    public long getCachesSize() {
        List<RepositoryManagement> repositories = this.repositories();
        long size = 0L;
        for (RepositoryManagement repository : repositories) {
            size += repository.getCacheSize();
        }
        return size;
    }

    @Override
    public String listRemoteSessions() {
        List<RepositoryManagement> repositories = this.repositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Actives remote session for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>");
            buf.append("<br/>");
        }
        return buf.toString();
    }

    @Override
    public BinaryManagerStatus gcBinaries(boolean delete) {
        BinaryGarbageCollector gc;
        BinaryManagerStatus status = new BinaryManagerStatus();
        List<RepositoryManagement> repositories = this.repositories();
        long start = System.currentTimeMillis();
        LinkedHashMap<String, BinaryGarbageCollector> repogcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        LinkedHashMap<String, BinaryGarbageCollector> gcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        for (RepositoryManagement repository : repositories) {
            String gcid;
            gc = repository.getBinaryGarbageCollector();
            if (gc == null) {
                // empty if block
            }
            if (gcs.containsKey(gcid = gc.getId())) {
                gc = (BinaryGarbageCollector)gcs.get(gcid);
            } else {
                gcs.put(gcid, gc);
                gc.start();
            }
            repogcs.put(repository.getName(), gc);
        }
        for (RepositoryManagement repository : repositories) {
            gc = (BinaryGarbageCollector)repogcs.get(repository.getName());
            repository.markReferencedBinaries(gc);
        }
        for (BinaryGarbageCollector gc2 : gcs.values()) {
            gc2.stop(delete);
            BinaryManagerStatus s = gc2.getStatus();
            status.numBinaries += s.numBinaries;
            status.sizeBinaries += s.sizeBinaries;
            status.numBinariesGC += s.numBinariesGC;
            status.sizeBinariesGC += s.sizeBinariesGC;
        }
        status.gcDuration = System.currentTimeMillis() - start;
        return status;
    }

    @Override
    public boolean isBinariesGCInProgress() {
        List<RepositoryManagement> repositories = this.repositories();
        for (RepositoryManagement repo : repositories) {
            BinaryGarbageCollector gc = repo.getBinaryGarbageCollector();
            if (!(gc != null & gc.isInProgress())) continue;
            return true;
        }
        return false;
    }
}

