/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.ConnectionSpecImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionManagerImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionRequestInfoImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
RepositoryManagement {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactoryImpl.class);
    private static final long serialVersionUID = 1L;
    private final RepositoryDescriptor repositoryDescriptor;
    private transient ResourceAdapter resourceAdapter;
    private transient PrintWriter out;
    private RepositoryImpl repository;
    private static final Pattern KEYVALUE = Pattern.compile("([^=]*)=(.*)");

    public ManagedConnectionFactoryImpl() {
        this(new RepositoryDescriptor());
    }

    public ManagedConnectionFactoryImpl(RepositoryDescriptor repositoryDescriptor) {
        this.repositoryDescriptor = repositoryDescriptor;
        if (repositoryDescriptor.properties == null) {
            repositoryDescriptor.properties = new HashMap();
        }
    }

    public void setName(String name) {
        this.repositoryDescriptor.name = name;
    }

    public String getName() {
        return this.repositoryDescriptor.name;
    }

    public void setXaDataSource(String xaDataSourceName) {
        this.repositoryDescriptor.xaDataSourceName = xaDataSourceName;
    }

    public String getXaDataSource() {
        return this.repositoryDescriptor.xaDataSourceName;
    }

    public void setProperty(String property) {
        this.repositoryDescriptor.properties.putAll(ManagedConnectionFactoryImpl.parseProperties(property));
    }

    public String getProperty() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this.resourceAdapter = resourceAdapter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new ConnectionManagerImpl());
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(this, connectionManager);
        log.debug((Object)("Created repository factory (" + connectionFactory + ')'));
        return connectionFactory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        assert (connectionRequestInfo instanceof ConnectionRequestInfoImpl);
        this.initialize();
        return new ManagedConnectionImpl(this, (ConnectionRequestInfoImpl)connectionRequestInfo);
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        for (Object candidate : set) {
            ManagedConnectionImpl managedConnection;
            if (!(candidate instanceof ManagedConnectionImpl) || !this.equals((managedConnection = (ManagedConnectionImpl)candidate).getManagedConnectionFactory())) continue;
            log.debug((Object)("matched: " + managedConnection));
            if (log.isTraceEnabled()) {
                log.trace((Object)"debug stack trace", (Throwable)new Exception());
            }
            return managedConnection;
        }
        return null;
    }

    public int getActiveSessionsCount() {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.getActiveSessionsCount();
    }

    public int clearCaches() {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.clearCaches();
    }

    public long getCacheSize() {
        return this.repository.getCacheSize();
    }

    public long getCachePristineSize() {
        return this.repository.getCachePristineSize();
    }

    public long getCacheSelectionSize() {
        return this.repository.getCacheSelectionSize();
    }

    public void processClusterInvalidationsNext() {
        if (this.repository != null) {
            this.repository.processClusterInvalidationsNext();
        }
    }

    public BinaryGarbageCollector getBinaryGarbageCollector() {
        if (this.repository == null) {
            return null;
        }
        return this.repository.getBinaryGarbageCollector();
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        if (this.repository != null) {
            this.repository.markReferencedBinaries(gc);
        }
    }

    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        if (this.repository == null) {
            return 0;
        }
        return this.repository.cleanupDeletedDocuments(max, beforeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws StorageException {
        ManagedConnectionFactoryImpl managedConnectionFactoryImpl = this;
        synchronized (managedConnectionFactoryImpl) {
            if (this.repository == null) {
                this.repositoryDescriptor.mergeFrom(ManagedConnectionFactoryImpl.getRepositoryDescriptor(this.repositoryDescriptor.name));
                this.repository = new RepositoryImpl(this.repositoryDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ManagedConnectionFactoryImpl managedConnectionFactoryImpl = this;
        synchronized (managedConnectionFactoryImpl) {
            if (this.repository != null) {
                try {
                    this.repository.close();
                }
                catch (StorageException e) {
                    log.error((Object)"Cannot close repository", (Throwable)e);
                }
            }
        }
    }

    protected static RepositoryDescriptor getRepositoryDescriptor(String name) throws StorageException {
        org.nuxeo.ecm.core.repository.RepositoryDescriptor d = NXCore.getRepositoryService().getRepositoryManager().getDescriptor(name);
        try {
            XMap xmap = new XMap();
            xmap.register(RepositoryDescriptor.class);
            return (RepositoryDescriptor)xmap.load((InputStream)new FileInputStream(d.getConfigurationFile()));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected SessionImpl getConnection(ConnectionSpecImpl connectionSpec) throws StorageException {
        return this.repository.getConnection((ConnectionSpec)connectionSpec);
    }

    public static Map<String, String> parseProperties(String expr) {
        String SPECIAL = "\u1fff";
        HashMap<String, String> props = new HashMap<String, String>();
        for (String kv : expr.replace(";;", SPECIAL).split(";")) {
            if ("".equals(kv = kv.replace(SPECIAL, ";"))) continue;
            Matcher m = KEYVALUE.matcher(kv);
            if (m == null || !m.matches()) {
                log.error((Object)("Invalid property expression: " + kv));
                continue;
            }
            props.put(m.group(1), m.group(2));
        }
        return props;
    }
}

