/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.list;

import com.sun.facelets.tag.jsf.ComponentSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.platform.el.FieldAdapterManager;
import org.nuxeo.ecm.platform.ui.web.component.ResettableComponent;
import org.nuxeo.ecm.platform.ui.web.component.list.StampState;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.EditableModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.EditableModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.model.impl.ProtectedEditableModelImpl;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class UIEditableList
extends UIInput
implements NamingContainer,
ResettableComponent {
    public static final String COMPONENT_TYPE = UIEditableList.class.getName();
    public static final String COMPONENT_FAMILY = UIEditableList.class.getName();
    private static final Log log = LogFactory.getLog(UIEditableList.class);
    private static final Object _NULL = new Object();
    protected String model = "";
    protected Object template;
    protected Boolean diff;
    protected Integer number;
    protected Boolean removeEmpty;
    private InternalState state;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    protected final InternalState getInternalState(boolean create) {
        if (this.state == null && create) {
            this.state = new InternalState();
        }
        return this.state;
    }

    protected final StampState getStampState() {
        InternalState iState = this.getInternalState(true);
        if (iState._stampState == null) {
            iState._stampState = new StampState();
        }
        return iState._stampState;
    }

    protected final void initializeState(boolean force) {
        InternalState iState = this.getInternalState(true);
        if (!iState._isInitialized || force) {
            iState._isInitialized = true;
        }
    }

    public Object saveState(FacesContext context) {
        EditableModel editableModel;
        StampState stampState;
        Object superState = super.saveState(context);
        InternalState iState = this.getInternalState(false);
        if (iState != null) {
            stampState = iState._stampState;
            editableModel = iState._model;
        } else {
            stampState = null;
            editableModel = null;
        }
        if (superState != null || stampState != null) {
            return new Object[]{superState, stampState, this.getSubmittedValue(), editableModel, this.model, this.template, this.diff, this.number, this.removeEmpty};
        }
        return null;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof ListProperty) {
            try {
                value = ((ListProperty)value).getValue();
                value = FieldAdapterManager.getValueForDisplay((Object)value);
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
        }
        return value;
    }

    public void restoreState(FacesContext context, Object state) {
        Object editableModel;
        Object submittedValue;
        Object stampState;
        Object superState;
        Object[] array = (Object[])state;
        if (array != null) {
            superState = array[0];
            stampState = array[1];
            submittedValue = array[2];
            editableModel = array[3];
            this.model = (String)array[4];
            this.template = array[5];
            this.diff = (Boolean)array[6];
            this.number = (Integer)array[7];
            this.removeEmpty = (Boolean)array[8];
        } else {
            superState = null;
            stampState = null;
            submittedValue = null;
            editableModel = null;
        }
        super.restoreState(context, superState);
        this.setSubmittedValue(submittedValue);
        if (stampState != null || this.model != null) {
            InternalState iState = this.getInternalState(true);
            iState._stampState = (StampState)stampState;
            iState._model = (EditableModel)editableModel;
        } else {
            InternalState iState = this.getInternalState(false);
            if (iState != null) {
                iState._stampState = (StampState)stampState;
                iState._model = (EditableModel)editableModel;
            }
        }
    }

    protected static boolean valueChanged(Object cached, Object current) {
        boolean changed = false;
        if (cached == null) {
            changed = current != null;
        } else if (current == null) {
            changed = true;
        } else if (cached instanceof Object[] && current instanceof Object[]) {
            Object[] cachedArray = (Object[])cached;
            Object[] currentArray = (Object[])current;
            if (cachedArray.length != currentArray.length) {
                return true;
            }
            for (int i = 0; i < cachedArray.length; ++i) {
                if (!UIEditableList.valueChanged(cachedArray[i], currentArray[i])) continue;
                return true;
            }
        } else if (cached instanceof List && current instanceof List) {
            List cachedList = (List)cached;
            List currentList = (List)current;
            if (cachedList.size() != currentList.size()) {
                return true;
            }
            for (int i = 0; i < cachedList.size(); ++i) {
                if (!UIEditableList.valueChanged(cachedList.get(i), currentList.get(i))) continue;
                return true;
            }
        } else if (cached instanceof Map && current instanceof Map) {
            Map cachedMap = (Map)cached;
            Map currentMap = (Map)current;
            if (cachedMap.size() != currentMap.size()) {
                return true;
            }
            for (Object key : cachedMap.keySet()) {
                if (!UIEditableList.valueChanged(cachedMap.get(key), currentMap.get(key))) continue;
                return true;
            }
        } else {
            changed = !cached.equals(current);
        }
        return changed;
    }

    protected void flushCachedModel() {
        InternalState iState = this.getInternalState(true);
        Object value = this.getValue();
        Object cachedValue = null;
        if (iState._model != null) {
            cachedValue = iState._model.getOriginalData();
        }
        if (UIEditableList.valueChanged(cachedValue, value)) {
            iState._value = value;
            iState._model = this.createEditableModel(iState._model, value);
        }
    }

    @Override
    public void resetCachedModel() {
        InternalState iState = this.getInternalState(true);
        Object value = this.getValue();
        iState._value = value;
        iState._model = this.createEditableModel(iState._model, value);
    }

    protected final Object saveRequestMapModelValue() {
        FacesContext context;
        Map requestMap;
        String modelName = this.getModel();
        if (modelName != null && (requestMap = (context = this.getFacesContext()).getExternalContext().getRequestMap()).containsKey(modelName)) {
            return requestMap.get(modelName);
        }
        return null;
    }

    protected final void restoreRequestMapModelValue(Object value) {
        String modelName = this.getModel();
        if (modelName != null) {
            FacesContext context = this.getFacesContext();
            Map requestMap = context.getExternalContext().getRequestMap();
            if (value == null) {
                requestMap.remove(modelName);
            } else {
                requestMap.put(modelName, value);
            }
        }
    }

    protected final void preRowDataChange() {
        StampState stampState = this.getStampState();
        FacesContext context = this.getFacesContext();
        Integer currencyObj = this.getRowKey();
        int position = 0;
        for (UIComponent stamp : this.getChildren()) {
            if (stamp.isTransient()) continue;
            Object state = StampState.saveStampState(context, stamp);
            String stampId = String.valueOf(position++);
            stampState.put(currencyObj, stampId, state);
        }
    }

    protected final void postRowDataChange() {
        StampState stampState = this.getStampState();
        FacesContext context = this.getFacesContext();
        Integer currencyObj = this.getRowKey();
        String modelName = this.getModel();
        if (modelName != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            EditableModel model = this.getEditableModel();
            if (model == null || !model.isRowAvailable()) {
                requestMap.remove(modelName);
            } else {
                requestMap.put(modelName, new ProtectedEditableModelImpl(model));
            }
        }
        int position = 0;
        for (UIComponent stamp : this.getChildren()) {
            Object iniStateObj;
            String stampId;
            Object state;
            if (stamp.isTransient()) continue;
            if ((state = stampState.get(currencyObj, stampId = String.valueOf(position++))) == null && (state = stampState.get(iniStateObj = this.getCurrencyKeyForInitialStampState(), stampId)) == null) {
                log.error((Object)("There was no initial stamp state for currencyKey:" + currencyObj + " and currencyKeyForInitialStampState:" + iniStateObj + " and stampId:" + stampId));
                continue;
            }
            StampState.restoreStampState(context, stamp, state);
        }
    }

    protected Object getCurrencyKeyForInitialStampState() {
        InternalState iState = this.getInternalState(false);
        if (iState == null) {
            return null;
        }
        Object rowKey = iState._initialStampStateKey;
        return rowKey == _NULL ? null : rowKey;
    }

    public final EditableModel getEditableModel() {
        InternalState iState = this.getInternalState(true);
        if (iState._model == null) {
            this.initializeState(false);
            iState._value = this.getValue();
            iState._model = this.createEditableModel(null, iState._value);
            assert (iState._model != null);
        }
        if (iState._initialStampStateKey == _NULL && iState._model != null) {
            iState._initialStampStateKey = iState._model.getRowKey();
        }
        return iState._model;
    }

    protected EditableModel createEditableModel(EditableModel current, Object value) {
        EditableModelImpl model = new EditableModelImpl(value);
        Integer defaultNumber = this.getNumber();
        int missing = 0;
        if (defaultNumber != null) {
            missing = defaultNumber - model.size();
        }
        if (defaultNumber != null && missing > 0) {
            try {
                Object template = this.getTemplate();
                if (template instanceof Serializable) {
                    Serializable serializableTemplate = (Serializable)template;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(out);
                    oos.writeObject(serializableTemplate);
                    oos.close();
                    for (int i = 0; i < missing; ++i) {
                        byte[] pickled = out.toByteArray();
                        ByteArrayInputStream in = new ByteArrayInputStream(pickled);
                        ObjectInputStream ois = new ObjectInputStream(in);
                        Object newTemplate = ois.readObject();
                        model.addValue(newTemplate);
                    }
                } else {
                    log.warn((Object)"Template is not serializable, cannot clone to add unreferenced value into model.");
                    model.addValue(template);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        model.setRowIndex(-1);
        assert (model.getRowIndex() == -1) : "RowIndex did not reset to -1";
        return model;
    }

    public final boolean isRowAvailable() {
        return this.getEditableModel().isRowAvailable();
    }

    public final boolean isRowModified() {
        return this.getEditableModel().isRowModified();
    }

    public final int getRowCount() {
        return this.getEditableModel().getRowCount();
    }

    public final int getRowIndex() {
        return this.getEditableModel().getRowIndex();
    }

    public final Integer getRowKey() {
        return this.getEditableModel().getRowKey();
    }

    public final Object getRowData() {
        EditableModel model = this.getEditableModel();
        return model.isRowAvailable() ? model.getRowData() : null;
    }

    public void setRowIndex(int rowIndex) {
        this.preRowDataChange();
        this.getEditableModel().setRowIndex(rowIndex);
        this.postRowDataChange();
    }

    public void setRowKey(Integer rowKey) {
        this.getEditableModel().setRowKey(rowKey);
        this.postRowDataChange();
    }

    public final void recordValueModified(int index, Object newValue) {
        this.getEditableModel().recordValueModified(index, newValue);
    }

    public boolean addValue(Object value) {
        return this.getEditableModel().addValue(value);
    }

    public void insertValue(int index, Object value) {
        this.getEditableModel().insertValue(index, value);
    }

    public Object moveValue(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    public Object removeValue(int index) {
        return this.getEditableModel().removeValue(index);
    }

    public String getModel() {
        if (this.model != null) {
            return this.model;
        }
        ValueExpression ve = this.getValueExpression("model");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Object getTemplate() {
        if (this.template != null) {
            return this.template;
        }
        ValueExpression ve = this.getValueExpression("template");
        if (ve != null) {
            try {
                Object res = ve.getValue(this.getFacesContext().getELContext());
                if (res instanceof String) {
                    res = ComponentTagUtils.resolveElExpression(this.getFacesContext(), (String)res);
                }
                return res;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public final void setTemplate(Object template) {
        this.template = template;
    }

    public Boolean getDiff() {
        if (this.diff != null) {
            return this.diff;
        }
        ValueExpression ve = this.getValueExpression("diff");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setDiff(Boolean diff) {
        this.diff = diff;
    }

    public Integer getNumber() {
        if (this.number != null) {
            return this.number;
        }
        ValueExpression ve = this.getValueExpression("number");
        if (ve != null) {
            try {
                return ((Number)ve.getValue(this.getFacesContext().getELContext())).intValue();
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Boolean getRemoveEmpty() {
        if (this.removeEmpty != null) {
            return this.removeEmpty;
        }
        ValueExpression ve = this.getValueExpression("removeEmpty");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setRemoveEmpty(Boolean removeEmpty) {
        this.removeEmpty = removeEmpty;
    }

    public String getContainerClientId(FacesContext context) {
        String id = super.getClientId(context);
        int index = this.getRowIndex();
        if (index != -1) {
            id = id + ':' + String.valueOf(index);
        }
        return id;
    }

    public String getRendererType() {
        return null;
    }

    public void setRendererType(String rendererType) {
    }

    public final void encodeBegin(FacesContext context) throws IOException {
        this.initializeState(false);
        this.flushCachedModel();
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.processFacetsAndChildren(context, PhaseId.RENDER_RESPONSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) {
        if (event instanceof EditableModelRowEvent) {
            EditableModelRowEvent rowEvent = (EditableModelRowEvent)event;
            Integer old = this.getRowKey();
            Object requestMapValue = this.saveRequestMapModelValue();
            try {
                this.setRowKey(rowEvent.getKey());
                FacesEvent wrapped = rowEvent.getEvent();
                wrapped.getComponent().broadcast(wrapped);
                this.setRowKey(old);
            }
            finally {
                this.restoreRequestMapModelValue(requestMapValue);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getSource() == this) {
            InternalState iState = this.getInternalState(true);
            iState._hasEvent = true;
        }
        Integer currencyKey = this.getRowKey();
        event = new EditableModelRowEvent((UIComponent)this, event, currencyKey);
        super.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.initializeState(false);
        InternalState iState = this.getInternalState(true);
        iState._isFirstRender = false;
        this.flushCachedModel();
        iState._hasEvent = false;
        this.processFacetsAndChildren(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.initializeState(true);
        this.processFacetsAndChildren(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        Boolean setDiff;
        List submitted;
        if (!this.isRendered()) {
            return;
        }
        this.initializeState(true);
        this.processFacetsAndChildren(context, PhaseId.UPDATE_MODEL_VALUES);
        EditableModel model = this.getEditableModel();
        if (model.isDirty()) {
            Boolean removeEmpty = this.getRemoveEmpty();
            Object data = model.getWrappedData();
            Object template = this.getTemplate();
            if (removeEmpty.booleanValue() && data instanceof List) {
                List dataList = (List)data;
                for (int i = dataList.size() - 1; i > -1; --i) {
                    Object item = dataList.get(i);
                    if (item != null && !item.equals(template)) continue;
                    model.removeValue(i);
                }
            }
        }
        if ((submitted = model.getWrappedData()) == null) {
            submitted = Collections.emptyList();
        }
        this.setSubmittedValue(submitted);
        this.executeValidate(context);
        if (this.isValid() && this.isLocalValueSet() && (setDiff = this.getDiff()).booleanValue()) {
            this.setValue(model.getListDiff());
        }
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        } else {
            this.resetCachedModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        Exception exception = null;
        List stamps = this.getChildren();
        int oldIndex = this.getRowIndex();
        int end = this.getRowCount();
        Object requestMapValue = this.saveRequestMapModelValue();
        try {
            int first;
            for (int i = first = 0; i < end; ++i) {
                this.setRowIndex(i);
                if (this.isRowAvailable()) {
                    for (UIComponent stamp : stamps) {
                        this.processComponent(context, stamp, phaseId);
                    }
                    if (phaseId != PhaseId.UPDATE_MODEL_VALUES || !this.isRowModified()) continue;
                    this.recordValueModified(i, this.getRowData());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.setRowIndex(oldIndex);
            this.restoreRequestMapModelValue(requestMapValue);
        }
        if (exception != null && exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
    }

    protected final void processComponent(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component != null) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                component.processDecodes(context);
            } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                component.processValidators(context);
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                component.processUpdates(context);
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                try {
                    ComponentSupport.encodeRecursive((FacesContext)context, (UIComponent)component);
                }
                catch (IOException err) {
                    log.error((Object)("Error while rendering component " + component));
                }
            } else {
                throw new IllegalArgumentException("Bad PhaseId:" + phaseId);
            }
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        String myId = super.getClientId(context);
        if (clientId.equals(myId)) {
            try {
                callback.invokeContextCallback(context, (UIComponent)this);
                return true;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        Exception exception = null;
        List stamps = this.getChildren();
        int oldIndex = this.getRowIndex();
        int end = this.getRowCount();
        boolean found = false;
        Object requestMapValue = this.saveRequestMapModelValue();
        try {
            int first;
            for (int i = first = 0; i < end; ++i) {
                this.setRowIndex(i);
                if (this.isRowAvailable()) {
                    for (UIComponent stamp : stamps) {
                        found = stamp.invokeOnComponent(context, clientId, callback);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.setRowIndex(oldIndex);
            this.restoreRequestMapModelValue(requestMapValue);
        }
        if (exception != null && exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return found;
    }

    static /* synthetic */ Object access$000() {
        return _NULL;
    }

    private static final class InternalState
    implements Serializable {
        private static final long serialVersionUID = 4730664880938551346L;
        private transient boolean _hasEvent = false;
        private transient Object _value;
        private transient boolean _isFirstRender = true;
        private transient boolean _isInitialized = false;
        private transient Object _initialStampStateKey = UIEditableList.access$000();
        private EditableModel _model;
        private StampState _stampState;

        private InternalState() {
        }
    }
}

