/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisPool
extends Pool<Jedis> {
    public JedisPool(GenericObjectPool.Config poolConfig, String host) {
        this(poolConfig, host, 6379, 2000, null, 0);
    }

    public JedisPool(String host, int port) {
        this(new GenericObjectPool.Config(), host, port, 2000, null, 0);
    }

    public JedisPool(String host) {
        URI uri = URI.create(host);
        if (uri.getScheme() != null && uri.getScheme().equals("redis")) {
            String h = uri.getHost();
            int port = uri.getPort();
            String password = uri.getUserInfo().split(":", 2)[1];
            int database = Integer.parseInt(uri.getPath().split("/", 2)[1]);
            this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(h, port, 2000, password, database), new GenericObjectPool.Config());
        } else {
            this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(host, 6379, 2000, null, 0), new GenericObjectPool.Config());
        }
    }

    public JedisPool(URI uri) {
        String h = uri.getHost();
        int port = uri.getPort();
        String password = uri.getUserInfo().split(":", 2)[1];
        int database = Integer.parseInt(uri.getPath().split("/", 2)[1]);
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(h, port, 2000, password, database), new GenericObjectPool.Config());
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout, String password) {
        this(poolConfig, host, port, timeout, password, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port) {
        this(poolConfig, host, port, 2000, null, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout) {
        this(poolConfig, host, port, timeout, null, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout, String password, int database) {
        super(poolConfig, (PoolableObjectFactory)new JedisFactory(host, port, timeout, password, database));
    }

    @Override
    public void returnBrokenResource(BinaryJedis resource) {
        this.returnBrokenResourceObject(resource);
    }

    @Override
    public void returnResource(BinaryJedis resource) {
        this.returnResourceObject(resource);
    }

    private static class JedisFactory
    extends BasePoolableObjectFactory {
        private final String host;
        private final int port;
        private final int timeout;
        private final String password;
        private final int database;

        public JedisFactory(String host, int port, int timeout, String password, int database) {
            this.host = host;
            this.port = port;
            this.timeout = timeout;
            this.password = password;
            this.database = database;
        }

        public Object makeObject() throws Exception {
            Jedis jedis = new Jedis(this.host, this.port, this.timeout);
            jedis.connect();
            if (null != this.password) {
                jedis.auth(this.password);
            }
            if (this.database != 0) {
                jedis.select(this.database);
            }
            return jedis;
        }

        public void destroyObject(Object obj) throws Exception {
            Jedis jedis;
            if (obj instanceof Jedis && (jedis = (Jedis)obj).isConnected()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            if (obj instanceof Jedis) {
                Jedis jedis = (Jedis)obj;
                try {
                    return jedis.isConnected() && jedis.ping().equals("PONG");
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

