/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.PunctuationTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NumberRecognizer {
    private final PunctuationTrie<?> punctuation;
    private final CharProducer p;
    private State state = State.START;

    NumberRecognizer(PunctuationTrie<?> punctuation, CharProducer p) {
        this.punctuation = punctuation;
        this.p = p;
    }

    boolean recognize(int offset) {
        char ch = this.p.getBuffer()[offset];
        State newState = null;
        switch (this.state) {
            case START: {
                if ('0' == ch) {
                    newState = State.ZERO;
                    break;
                }
                if ('1' <= ch && '9' >= ch) {
                    newState = State.INTEGER;
                    break;
                }
                if ('.' == ch) {
                    newState = State.DOT;
                    break;
                }
                throw new AssertionError();
            }
            case ZERO: {
                if (ch >= '1' && ch <= '9') {
                    newState = State.OCTAL;
                    break;
                }
                if (ch == '.') {
                    newState = State.INTEGER_DOT;
                    break;
                }
                if (ch == '0') {
                    newState = State.ZERO;
                    break;
                }
                if ((ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) break;
                if (ch == 'x' || ch == 'X') {
                    newState = State.HEX_PRE;
                    break;
                }
                if (ch != 'e' && ch != 'E') break;
                newState = State.EXP_PRE;
                break;
            }
            case DOT: {
                if (NumberRecognizer.isDecimal(ch)) {
                    newState = State.FRACTION;
                    break;
                }
                return false;
            }
            case INTEGER: {
                if (NumberRecognizer.isDecimal(ch)) {
                    newState = State.INTEGER;
                    break;
                }
                if ('.' == ch) {
                    newState = State.INTEGER_DOT;
                    break;
                }
                if (ch != 'e' && ch != 'E') break;
                newState = State.EXP_PRE;
                break;
            }
            case INTEGER_DOT: {
                if (NumberRecognizer.isDecimal(ch)) {
                    newState = State.FRACTION;
                    break;
                }
                if (ch != 'e' && ch != 'E') break;
                newState = State.EXP_PRE;
                break;
            }
            case OCTAL: {
                if (ch < '0' || ch > '7') break;
                newState = State.OCTAL;
                break;
            }
            case HEX_PRE: {
                if (!NumberRecognizer.isDecimal(ch) && (ch < 'a' || ch > 'f') && (ch < 'A' || ch > 'F')) break;
                newState = State.HEX;
                break;
            }
            case HEX: {
                if (!NumberRecognizer.isDecimal(ch) && (ch < 'a' || ch > 'f') && (ch < 'A' || ch > 'F')) break;
                newState = State.HEX;
                break;
            }
            case FRACTION: {
                if (NumberRecognizer.isDecimal(ch)) {
                    newState = State.FRACTION;
                    break;
                }
                if (ch != 'e' && ch != 'E') break;
                newState = State.EXP_PRE;
                break;
            }
            case EXP_PRE: {
                if (NumberRecognizer.isDecimal(ch)) {
                    newState = State.EXPONENT;
                    break;
                }
                if (ch != '+' && ch != '-' || offset + 1 >= this.p.getLimit() || !NumberRecognizer.isDecimal(this.p.getBuffer()[offset + 1])) break;
                newState = State.EXP_SIGN;
                break;
            }
            case EXP_SIGN: {
                if (!NumberRecognizer.isDecimal(ch)) break;
                newState = State.EXPONENT;
                break;
            }
            case EXPONENT: {
                if (!NumberRecognizer.isDecimal(ch)) break;
                newState = State.EXPONENT;
                break;
            }
        }
        if (newState != null) {
            this.state = newState;
            return true;
        }
        if (this.endsToken(ch)) {
            return false;
        }
        this.state = State.WORD;
        return true;
    }

    State getState() {
        return this.state;
    }

    boolean isNumber() {
        return State.WORD != this.state;
    }

    boolean isHex() {
        return State.HEX == this.state;
    }

    boolean isOctal() {
        return State.OCTAL == this.state;
    }

    JsTokenType getTokenType() {
        switch (this.state) {
            case DOT: {
                return JsTokenType.PUNCTUATION;
            }
            case ZERO: 
            case INTEGER: 
            case OCTAL: 
            case HEX: {
                return JsTokenType.INTEGER;
            }
            case INTEGER_DOT: 
            case FRACTION: 
            case EXPONENT: {
                return JsTokenType.FLOAT;
            }
        }
        return JsTokenType.WORD;
    }

    private static boolean isDecimal(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private boolean endsToken(char ch) {
        return ch == '\"' || ch == '\'' || this.punctuation.contains(ch) || JsLexer.isJsSpace(ch);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START,
        ZERO,
        DOT,
        INTEGER,
        INTEGER_DOT,
        OCTAL,
        HEX_PRE,
        HEX,
        FRACTION,
        EXP_PRE,
        EXP_SIGN,
        EXPONENT,
        WORD;

    }
}

