/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.opensocial.Callback;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.plugin.Config;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GadgetRewriterMain {
    private Config config;
    private MessageContext mc = new MessageContext();
    private Map<InputSource, CharSequence> originalSources = new HashMap<InputSource, CharSequence>();

    public GadgetRewriterMain() {
        this.config = new Config(this.getClass(), System.err, "Cajole an OpenSocial gadget spec's Content");
    }

    public static void main(String[] argv) throws GadgetRewriteException, IOException, UriCallbackException, ParseException {
        GadgetRewriterMain grm = new GadgetRewriterMain();
        if (grm.init(argv)) {
            System.exit(grm.run());
        }
        System.exit(-1);
    }

    public boolean init(String[] argv) {
        return this.config.processArguments(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws GadgetRewriteException, IOException, UriCallbackException, ParseException {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        DefaultGadgetRewriter rewriter = new DefaultGadgetRewriter(BuildInfo.getInstance(), mq);
        rewriter.setCssSchema(this.config.getCssSchema(mq));
        rewriter.setHtmlSchema(this.config.getHtmlSchema(mq));
        rewriter.setDebugMode(this.config.debugMode());
        BufferedWriter w = new BufferedWriter(new FileWriter(this.config.getOutputBase()));
        try {
            Callback cb = new Callback(this.mc, this.originalSources);
            URI baseUri = this.config.getBaseUri();
            for (URI input : this.config.getInputUris()) {
                Reader r = cb.retrieve(new ExternalReference(input, null), null);
                CharProducer p = CharProducer.Factory.create(r, new InputSource(input));
                try {
                    rewriter.rewrite(baseUri, p, cb, this.config.getGadgetView(), w);
                }
                finally {
                    SnippetProducer sp = new SnippetProducer(this.originalSources, this.mc);
                    for (Message msg : mq.getMessages()) {
                        System.err.println(msg.getMessageLevel().name() + ": " + msg.format(this.mc));
                        System.err.println(sp.getSnippet(msg));
                        System.err.println();
                    }
                    r.close();
                }
            }
        }
        finally {
            ((Writer)w).close();
        }
        return 0;
    }

    public Config getConfig() {
        return this.config;
    }
}

