/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.io.IWritableResourceProvider;
import com.phloc.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WritableResourceProviderChain
extends ReadableResourceProviderChain
implements IWritableResourceProvider {
    protected final List<IWritableResourceProvider> m_aWritableResourceProviders = new ArrayList<IWritableResourceProvider>();

    public WritableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        super(iReadableResourceProviderArray);
        for (IReadableResourceProvider iReadableResourceProvider : iReadableResourceProviderArray) {
            if (!(iReadableResourceProvider instanceof IWritableResourceProvider)) continue;
            this.m_aWritableResourceProviders.add((IWritableResourceProvider)iReadableResourceProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    @Override
    public final boolean supportsWriting(@Nullable String string) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            if (!iWritableResourceProvider.supportsWriting(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IWritableResource getWritableResource(String string) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            if (!iWritableResourceProvider.supportsWriting(string)) continue;
            return iWritableResourceProvider.getWritableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle writing '" + string + "' by " + this.m_aReadingResourceProviders);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        WritableResourceProviderChain writableResourceProviderChain = (WritableResourceProviderChain)object;
        return ((Object)this.m_aWritableResourceProviders).equals(writableResourceProviderChain.m_aWritableResourceProviders);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aWritableResourceProviders)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("writableResProviders", this.m_aWritableResourceProviders).toString();
    }
}

