/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LocaleCache {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, Locale> s_aLocales = new HashMap<String, Locale>();
    private static final LocaleCache s_aInstance;

    private LocaleCache() {
    }

    private static void _initialAdd(@Nonnull Locale locale) {
        s_aLocales.put(locale.toString(), locale);
    }

    @Nullable
    public static Locale getLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return LocaleCache.getLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return LocaleCache.getLocale(stringArray[0], stringArray[1], "");
            }
        }
        return LocaleCache.getLocale(string, "", "");
    }

    @Nullable
    public static Locale getLocale(@Nullable String string, @Nullable String string2) {
        return LocaleCache.getLocale(string, string2, "");
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        Locale locale;
        String string4;
        String string5;
        String string6 = string == null ? "" : string.toLowerCase();
        String string7 = LocaleCache._buildLocaleString(string6, string5 = string2 == null ? "" : string2.toUpperCase(), string4 = string3 == null ? "" : string3);
        if (string7.length() == 0) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            locale = s_aLocales.get(string7);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (locale == null) {
            s_aRWLock.writeLock().lock();
            try {
                locale = s_aLocales.get(string7);
                if (locale == null) {
                    locale = new Locale(string6, string5, string4);
                    s_aLocales.put(string7, locale);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLocales() {
        s_aRWLock.readLock().lock();
        try {
            Set<Locale> set = ContainerHelper.newSet(s_aLocales.values());
            set.remove(CGlobal.LOCALE_ALL);
            set.remove(CGlobal.LOCALE_INDEPENDENT);
            Set<Locale> set2 = set;
            return set2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLanguages() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (Locale locale : LocaleCache.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            hashSet.add(LocaleCache.getLocale(string, null, null));
        }
        return hashSet;
    }

    public static boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return LocaleCache.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return LocaleCache.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return LocaleCache.containsLocale(string, "", "");
    }

    public static boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return LocaleCache.containsLocale(string, string2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4;
        String string5;
        String string6 = string == null ? "" : string.toLowerCase();
        String string7 = LocaleCache._buildLocaleString(string6, string5 = string2 == null ? "" : string2.toUpperCase(), string4 = string3 == null ? "" : string3);
        if (string7.length() == 0) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aLocales.containsKey(string7);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        LocaleCache._initialAdd(CGlobal.LOCALE_ALL);
        LocaleCache._initialAdd(CGlobal.LOCALE_INDEPENDENT);
        for (Locale object : Locale.getAvailableLocales()) {
            LocaleCache._initialAdd(object);
        }
        for (String string : Locale.getISOCountries()) {
            LocaleCache._initialAdd(new Locale("", string));
        }
        for (String string : Locale.getISOLanguages()) {
            LocaleCache._initialAdd(new Locale(string, ""));
        }
        s_aInstance = new LocaleCache();
    }
}

