/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.string;

import com.phloc.commons.string.StringHelper;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ToStringGenerator {
    public static final String CONSTANT_NULL = "null";
    public static final String CONSTANT_THIS = "this";
    public static final String CONSTANT_PASSWORD = "****";
    private static final int FIRST_FIELD = 1;
    private static final int APPENDED_CLOSING_BRACKET = 2;
    private final StringBuilder m_aSB = new StringBuilder("[");
    private final Object m_aSrc;
    private int m_nIndex = 0;

    public ToStringGenerator(@Nullable Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            int n = string.lastIndexOf(46);
            this.m_aSB.append(n == -1 ? string : string.substring(n + 1)).append("@0x").append(StringHelper.getHexStringLeadingZero(System.identityHashCode(object), 8));
        }
        this.m_aSrc = object;
    }

    private void _beforeAddField() {
        if ((this.m_nIndex & 1) == 0) {
            this.m_nIndex |= 1;
            if (this.m_aSB.length() > 1) {
                this.m_aSB.append(": ");
            }
        } else {
            this.m_aSB.append("; ");
        }
    }

    @Nonnull
    private ToStringGenerator _appendSuper(String string) {
        this._beforeAddField();
        this.m_aSB.append(string);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, boolean bl) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(bl);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable boolean[] blArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(blArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, byte by) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(by);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable byte[] byArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(byArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, char c) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(c);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable char[] cArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(cArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, double d) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(d);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable double[] dArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(dArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, float f) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(f);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable float[] fArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(fArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, int n) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(n);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable int[] nArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(nArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, long l) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(l);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable long[] lArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(lArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, short s) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(s);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable short[] sArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(sArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator appendPassword(@Nonnull String string) {
        return this.append(string, CONSTANT_PASSWORD);
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Enum<?> enum_) {
        return this.append(string, String.valueOf(enum_));
    }

    @Nonnull
    private String _getObjectValue(@Nullable Object object) {
        return object == null ? CONSTANT_NULL : (object == this.m_aSrc ? CONSTANT_THIS : object.toString());
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Object object) {
        if (object != null && object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.equals(Boolean.TYPE)) {
                return this.append(string, (boolean[])object);
            }
            if (clazz.equals(Byte.TYPE)) {
                return this.append(string, (byte[])object);
            }
            if (clazz.equals(Character.TYPE)) {
                return this.append(string, (char[])object);
            }
            if (clazz.equals(Double.TYPE)) {
                return this.append(string, (double[])object);
            }
            if (clazz.equals(Float.TYPE)) {
                return this.append(string, (float[])object);
            }
            if (clazz.equals(Integer.TYPE)) {
                return this.append(string, (int[])object);
            }
            if (clazz.equals(Long.TYPE)) {
                return this.append(string, (long[])object);
            }
            if (clazz.equals(Short.TYPE)) {
                return this.append(string, (short[])object);
            }
            return this.append(string, (Object[])object);
        }
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(this._getObjectValue(object));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Object[] objectArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=');
        if (objectArray == null) {
            this.m_aSB.append(CONSTANT_NULL);
        } else {
            int n = objectArray.length - 1;
            if (n == -1) {
                this.m_aSB.append("[]");
            } else {
                this.m_aSB.append('[');
                int n2 = 0;
                while (true) {
                    this.m_aSB.append(this._getObjectValue(objectArray[n2]));
                    if (n2 == n) break;
                    this.m_aSB.append(", ");
                    ++n2;
                }
                this.m_aSB.append(']');
            }
        }
        return this;
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable boolean[] blArray) {
        return blArray == null ? this : this.append(string, blArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable byte[] byArray) {
        return byArray == null ? this : this.append(string, byArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable char[] cArray) {
        return cArray == null ? this : this.append(string, cArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable double[] dArray) {
        return dArray == null ? this : this.append(string, dArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable float[] fArray) {
        return fArray == null ? this : this.append(string, fArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable int[] nArray) {
        return nArray == null ? this : this.append(string, nArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable long[] lArray) {
        return lArray == null ? this : this.append(string, lArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable short[] sArray) {
        return sArray == null ? this : this.append(string, sArray);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable Object object) {
        return object == null ? this : this.append(string, object);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable Object[] objectArray) {
        return objectArray == null ? this : this.append(string, objectArray);
    }

    @Nonnull
    public String toString() {
        if ((this.m_nIndex & 2) == 0) {
            this.m_nIndex |= 2;
            this.m_aSB.append(']');
        }
        return this.m_aSB.toString();
    }

    @Nonnull
    public static ToStringGenerator getDerived(@Nonnull String string) {
        return new ToStringGenerator(null)._appendSuper(string);
    }
}

