/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.IXMLIterationHandler;
import com.phloc.commons.xml.XMLHelper;
import com.phloc.commons.xml.serialize.AbstractSerializerPhloc;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLEmitterPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.Writer;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class XMLSerializerPhloc
extends AbstractSerializerPhloc<Node> {
    public XMLSerializerPhloc() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public XMLSerializerPhloc(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    private void _writeNode(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Node node) {
        short s = node.getNodeType();
        if (s == 1) {
            this._writeElement(iXMLIterationHandler, (Element)node);
        } else if (s == 3) {
            XMLSerializerPhloc._writeText(iXMLIterationHandler, (Text)node);
        } else if (s == 4) {
            XMLSerializerPhloc._writeCDATA(iXMLIterationHandler, (CDATASection)node);
        } else if (s == 8) {
            this._writeComment(iXMLIterationHandler, (Comment)node);
        } else if (s == 5) {
            XMLSerializerPhloc._writeEntityReference(iXMLIterationHandler, (EntityReference)node);
        } else if (s == 9) {
            this._writeDocument(iXMLIterationHandler, (Document)node);
        } else if (s == 10) {
            this._writeDocumentType(iXMLIterationHandler, (DocumentType)node);
        } else if (s == 7) {
            XMLSerializerPhloc._writeProcessingInstruction(iXMLIterationHandler, (ProcessingInstruction)node);
        } else {
            throw new IllegalArgumentException("Passed node type " + s + " is not yet supported");
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Document document) {
        int n;
        Object object;
        if (this.m_aSettings.getFormat().isXML()) {
            object = null;
            n = 0;
            try {
                object = document.getXmlVersion();
                n = document.getXmlStandalone() ? 1 : 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EXMLVersion eXMLVersion = EXMLVersion.getFromVersionOrDefault((String)object, this.m_aSettings.getXMLVersion());
            iXMLIterationHandler.onDocumentStart(eXMLVersion, this.m_aSettings.getCharset(), n != 0 || document.getDoctype() == null);
        }
        object = document.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            this._writeNode(iXMLIterationHandler, object.item(n));
        }
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull DocumentType documentType) {
        if (this.m_aSettings.getSerializeDocType().emit()) {
            iXMLIterationHandler.onDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull ProcessingInstruction processingInstruction) {
        iXMLIterationHandler.onProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull EntityReference entityReference) {
        iXMLIterationHandler.onEntityReference(entityReference.getNodeName());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Comment comment) {
        if (this.m_aSettings.getSerializeComments().emit()) {
            iXMLIterationHandler.onComment(comment.getData());
        }
    }

    private static void _writeText(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Text text) {
        iXMLIterationHandler.onText(text.getData(), true);
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Text text) {
        iXMLIterationHandler.onCDATA(text.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Element element) {
        Object object;
        String string = element.getLocalName() != null ? element.getLocalName() : element.getTagName();
        Document document = element.getOwnerDocument();
        NodeList nodeList = element.getChildNodes();
        boolean bl = nodeList.getLength() > 0;
        boolean bl2 = document != null && element.equals(document.getDocumentElement());
        boolean bl3 = element.getPreviousSibling() == null || !XMLHelper.isTextNode(element.getPreviousSibling()) || bl2;
        boolean bl4 = element.getNextSibling() == null || !XMLHelper.isTextNode(element.getNextSibling());
        boolean bl5 = bl && !XMLHelper.isTextNode(element.getFirstChild());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = (Attr)namedNodeMap.item(i);
            treeMap.put(object.getName(), object.getValue());
        }
        this.m_aNSStack.push(treeMap);
        try {
            String string2;
            String string3 = StringHelper.getNotNull(element.getNamespaceURI());
            object = StringHelper.getNotNull(this.m_aNSStack.getDefaultNamespaceURI());
            boolean bl6 = string3.equals(object);
            String string4 = string2 = bl6 ? null : this.m_aNSStack.getUsedPrefixOfNamespace(string3);
            if (!(string2 != null || bl6 || bl2 && string3.length() <= 0)) {
                string2 = this.m_aNSStack.getMappedPrefix(string3);
                if (string2 == null && !bl2) {
                    string2 = this.m_aNSStack.createUniquePrefix();
                }
                if (StringHelper.hasNoText(string2)) {
                    treeMap.put("xmlns", string3);
                } else {
                    treeMap.put("xmlns:" + string2, string3);
                }
                this.m_aNSStack.addNamespaceMapping(string2, string3);
            }
            if (this.m_aSettings.getIndent().isIndent() && bl3 && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onElementStart(string2, string, treeMap, bl);
            if (bl) {
                if (this.m_aSettings.getIndent().isAlign() && bl5) {
                    iXMLIterationHandler.onContentElementWhitespace(NEWLINE);
                }
                this.m_aIndent.append("  ");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this._writeNode(iXMLIterationHandler, nodeList.item(i));
                }
                this.m_aIndent.delete(this.m_aIndent.length() - "  ".length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bl5 && this.m_aIndent.length() > 0) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
                }
            }
            iXMLIterationHandler.onElementEnd(string2, string, bl);
            if (this.m_aSettings.getIndent().isAlign() && bl4) {
                iXMLIterationHandler.onContentElementWhitespace(NEWLINE);
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    @Override
    public void write(@Nonnull Node node, @Nonnull @WillNotClose Writer writer) {
        XMLEmitterPhloc xMLEmitterPhloc = new XMLEmitterPhloc(writer, this.m_aSettings);
        this._writeNode(xMLEmitterPhloc, node);
        StreamUtils.flush(writer);
    }

    public void write(@Nonnull Node node, @Nonnull IXMLIterationHandler iXMLIterationHandler) {
        this._writeNode(iXMLIterationHandler, node);
    }
}

