/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.adapters.AbstractLongCollectionCollection;
import org.apache.commons.collections.primitives.adapters.CollectionLongCollection;
import org.apache.commons.collections.primitives.adapters.LongListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.LongListList;

abstract class AbstractLongListList
extends AbstractLongCollectionCollection
implements List<Long> {
    AbstractLongListList() {
    }

    @Nonnull
    protected abstract LongList getLongList();

    @Override
    @Nonnull
    protected final LongCollection getLongCollection() {
        return this.getLongList();
    }

    @Override
    public void add(int n, @Nonnull Long l) {
        this.getLongList().add(n, l);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Long> collection) {
        return this.getLongList().addAll(n, CollectionLongCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Long get(int n) {
        return this.getLongList().get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getLongList().indexOf((Long)object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getLongList().lastIndexOf((Long)object);
    }

    @Override
    public ListIterator<Long> listIterator() {
        return LongListIteratorListIterator.wrap(this.getLongList().listIterator());
    }

    @Override
    public ListIterator<Long> listIterator(int n) {
        return LongListIteratorListIterator.wrap(this.getLongList().listIterator(n));
    }

    @Override
    @Nonnull
    public Long remove(int n) {
        return this.getLongList().removeElementAt(n);
    }

    @Override
    @Nonnull
    public Long set(int n, Long l) {
        return this.getLongList().set(n, l);
    }

    @Override
    public List<Long> subList(int n, int n2) {
        return LongListList.wrap(this.getLongList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Long> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Long l = iterator.next();
            Object e = iterator2.next();
            if (!(null == l ? null != e : !((Object)l).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getLongList()).hashCode();
    }
}

