/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.util.HashMap;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;

@Operation(id="Workflow.CompleteTaskOperation", category="Workflow Context", label="Complete task", requires="Workflow", description="Completes the input task. If this is the last task the workflow will continue. Returns back the task document. \"Status\" is the id of the button the user would have clicked to submit the task form (if the outgoing transitions of the workflow node that created the task have conditions depending on it).")
public class CompleteTaskOperation {
    public static final String ID = "Workflow.CompleteTaskOperation";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="status", required=false)
    protected String status;
    @Param(name="comment", required=false)
    protected String comment;
    @Context
    protected DocumentRoutingService documentRoutingService;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel completeTask(DocumentModel task) throws ClientException {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.comment != null) {
            data.put("comment", this.comment);
        }
        this.documentRoutingService.endTask(this.session, (Task)task.getAdapter(Task.class), new HashMap(), this.status);
        return task;
    }
}

