/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.CustomThemeNameFilter;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFactory;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.engines.EngineType;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentFactory;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.models.Info;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.nodes.NodeException;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.relations.DefaultPredicate;
import org.nuxeo.theme.relations.DyadicRelation;
import org.nuxeo.theme.relations.Predicate;
import org.nuxeo.theme.relations.Relation;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.templates.TemplateEngineType;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeParser;
import org.nuxeo.theme.themes.ThemeRepairer;
import org.nuxeo.theme.themes.ThemeSerializer;
import org.nuxeo.theme.themes.ThemeSet;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.Identifiable;
import org.nuxeo.theme.uids.UidManager;
import org.nuxeo.theme.views.ViewType;

public final class ThemeManager
implements Registrable {
    public static final String THEME_TOPIC = "org.nuxeo.theme";
    public static final String THEME_REGISTERED_EVENT_ID = "themeRegistered";
    private static final Log log = LogFactory.getLog(ThemeManager.class);
    private final Map<String, Long> lastModified = new HashMap<String, Long>();
    private final Map<String, ThemeElement> themes = new HashMap<String, ThemeElement>();
    private final Map<String, PageElement> pages = new HashMap<String, PageElement>();
    private final Map<String, List<Integer>> formatsByTypeName = new LinkedHashMap<String, List<Integer>>();
    private final Map<String, ModelType> modelsByClassname = new HashMap<String, ModelType>();
    private final Map<String, Map<String, Integer>> namedObjectsByTheme = new HashMap<String, Map<String, Integer>>();
    private final Map<Integer, String> themeOfNamedObjects = new HashMap<Integer, String>();
    private final Map<String, Info> infoMap = new HashMap<String, Info>();
    private static final Predicate PREDICATE_FORMAT_INHERIT = new DefaultPredicate("_ inherits from _");
    private final Map<String, String> cachedStyles = new HashMap<String, String>();
    private final Map<String, String> cachedResources = new HashMap<String, String>();
    private final Map<String, byte[]> cachedBinaries = new HashMap<String, byte[]>();
    private final List<String> resourceOrdering = new ArrayList<String>();
    private static File THEME_DIR;
    private static final FilenameFilter CUSTOM_THEME_FILENAME_FILTER;
    private static final int DEFAULT_THEME_INDENT = 2;
    private static final String COLLECTION_CSS_MARKER = "COLLECTION";
    private static final Pattern styleResourceNamePattern;

    public static void createThemeDir() {
        THEME_DIR = new File(Environment.getDefault().getData(), "themes");
        THEME_DIR.mkdirs();
    }

    public static File getThemeDir() {
        if (THEME_DIR == null || !THEME_DIR.exists()) {
            ThemeManager.createThemeDir();
        }
        return THEME_DIR;
    }

    @Override
    public synchronized void clear() {
        this.themes.clear();
        this.pages.clear();
        this.formatsByTypeName.clear();
        this.modelsByClassname.clear();
        this.namedObjectsByTheme.clear();
        this.themeOfNamedObjects.clear();
        this.infoMap.clear();
        this.cachedStyles.clear();
        this.cachedResources.clear();
        this.cachedBinaries.clear();
        this.resourceOrdering.clear();
        this.lastModified.clear();
    }

    public Map<String, Info> getGlobalInfoMap() {
        return this.infoMap;
    }

    public static boolean validateThemeName(String themeName) {
        return themeName.matches("^([a-zA-Z]|[a-zA-Z][a-zA-Z0-9_\\-]*?[a-zA-Z0-9])$");
    }

    public static String getCustomThemePath(String themeName) throws ThemeIOException {
        String themeFileName = String.format("theme-%s.xml", themeName);
        File file = new File(ThemeManager.getThemeDir(), themeFileName);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ThemeIOException("Could not get custom theme path: " + themeName, e);
        }
    }

    public static List<File> getCustomThemeFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : ThemeManager.getThemeDir().listFiles(CUSTOM_THEME_FILENAME_FILTER)) {
            files.add(f);
        }
        return files;
    }

    public static ThemeDescriptor customizeTheme(ThemeDescriptor themeDescriptor) throws ThemeException {
        String xmlSource;
        String themeName = themeDescriptor.getName();
        if (!themeDescriptor.isCustomizable()) {
            throw new ThemeException("Theme : " + themeName + " cannot be customized.");
        }
        ThemeSerializer serializer = new ThemeSerializer();
        try {
            xmlSource = serializer.serializeToXml(themeDescriptor.getSrc(), 0);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not serialize theme: " + themeName, e);
        }
        ThemeDescriptor newThemeDescriptor = ThemeManager.createCustomTheme(themeName);
        String newSrc = newThemeDescriptor.getSrc();
        try {
            Manager.getThemeManager().loadTheme(newSrc, xmlSource);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not update theme: " + newSrc, e);
        }
        try {
            ThemeManager.saveTheme(newSrc);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not save theme: " + newSrc, e);
        }
        newThemeDescriptor.setCustomization(true);
        return newThemeDescriptor;
    }

    public static ThemeDescriptor uncustomizeTheme(ThemeDescriptor themeDescriptor) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        String themeName = themeDescriptor.getName();
        if (!themeDescriptor.isCustomization()) {
            throw new ThemeException("Theme : " + themeName + " cannot be uncustomized.");
        }
        String themeSrc = themeDescriptor.getSrc();
        try {
            themeManager.deleteTheme(themeSrc);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not remove theme: " + themeSrc, e);
        }
        ThemeDescriptor newThemeDescriptor = ThemeManager.getThemeDescriptorByThemeName(themeName);
        ThemeManager.loadTheme(newThemeDescriptor);
        return newThemeDescriptor;
    }

    public static ThemeDescriptor createCustomTheme(String name) throws ThemeException {
        String path;
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeElement theme = (ThemeElement)ElementFactory.create("theme");
        theme.setName(name);
        Widget themeWidget = themeManager.createWidget();
        themeWidget.setName("theme view");
        ElementFormatter.setFormat(theme, themeWidget);
        PageElement page = (PageElement)ElementFactory.create("page");
        page.setName("default");
        Widget pageWidget = themeManager.createWidget();
        pageWidget.setName("page frame");
        Layout pageLayout = themeManager.createLayout();
        Style pageStyle = themeManager.createStyle();
        ElementFormatter.setFormat(page, pageWidget);
        ElementFormatter.setFormat(page, pageStyle);
        ElementFormatter.setFormat(page, pageLayout);
        try {
            theme.addChild(page);
        }
        catch (NodeException e) {
            throw new ThemeException(e.getMessage(), e);
        }
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.setName(name);
        try {
            path = ThemeManager.getCustomThemePath(name);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not get file path for theme: " + name);
        }
        String src = String.format("file:///%s", path);
        themeDescriptor.setSrc(src);
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        typeRegistry.register(themeDescriptor);
        themeManager.registerTheme(theme);
        try {
            ThemeManager.saveTheme(themeDescriptor.getSrc());
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not save theme: " + name, e);
        }
        return themeDescriptor;
    }

    public static void updateThemeDescriptors() {
        HashMap names = new HashMap();
        for (ThemeDescriptor themeDescriptor : ThemeManager.getThemeDescriptors()) {
            String themeName = themeDescriptor.getName();
            if (!names.containsKey(themeName)) {
                names.put(themeName, new ArrayList());
            }
            ((List)names.get(themeName)).add(themeDescriptor);
        }
        for (List themeDescriptors : names.values()) {
            for (ThemeDescriptor themeDescriptor : themeDescriptors) {
                themeDescriptor.setCustomized(true);
                themeDescriptor.setCustomization(false);
            }
            int size = themeDescriptors.size();
            ((ThemeDescriptor)themeDescriptors.get(size - 1)).setCustomized(false);
            if (size <= 1) continue;
            ((ThemeDescriptor)themeDescriptors.get(size - 1)).setCustomization(true);
        }
    }

    public static String getDefaultTheme(String applicationPath) {
        return ThemeManager.getDefaultTheme(applicationPath, null);
    }

    public static String getDefaultTheme(String ... paths) {
        NegotiationDef negotiation;
        String defaultTheme = "";
        ApplicationType application = null;
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        application = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, paths);
        if (application != null && (negotiation = application.getNegotiation()) != null) {
            defaultTheme = negotiation.getDefaultTheme();
        }
        return defaultTheme;
    }

    public static Set<String> getThemeNames(String templateEngine) {
        HashSet<String> names = new HashSet<String>();
        for (ThemeDescriptor themeDef : ThemeManager.getThemeDescriptors()) {
            if (themeDef.isCustomized() || templateEngine != null && !themeDef.isCompatibleWith(templateEngine)) continue;
            names.add(themeDef.getName());
        }
        return names;
    }

    public static ThemeDescriptor getThemeDescriptorByThemeName(String templateEngine, String themeName) {
        for (ThemeDescriptor themeDef : ThemeManager.getThemeDescriptors()) {
            String name;
            if (themeDef.isCustomized() || templateEngine != null && !themeDef.isCompatibleWith(templateEngine) || (name = themeDef.getName()) == null || !name.equals(themeName)) continue;
            return themeDef;
        }
        return null;
    }

    public static ThemeDescriptor getThemeDescriptorByThemeName(String themeName) {
        return ThemeManager.getThemeDescriptorByThemeName(null, themeName);
    }

    public static Set<String> getThemeNames() {
        return ThemeManager.getThemeNames(null);
    }

    public Set<String> getPageNames(String themeName) {
        ThemeElement theme = this.getThemeByName(themeName);
        LinkedHashSet<String> pageNames = new LinkedHashSet<String>();
        if (theme != null) {
            for (PageElement page : ThemeManager.getPagesOf(theme)) {
                pageNames.add(page.getName());
            }
        }
        return pageNames;
    }

    public static List<PageElement> getPagesOf(ThemeElement theme) {
        ArrayList<PageElement> themePages = new ArrayList<PageElement>();
        for (Node node : theme.getChildren()) {
            PageElement page = (PageElement)node;
            themePages.add(page);
        }
        return themePages;
    }

    public List<PageElement> getPagesOf(String themeName) {
        ThemeElement theme = this.getThemeByName(themeName);
        if (theme == null) {
            return null;
        }
        return ThemeManager.getPagesOf(theme);
    }

    public static ThemeElement getThemeOf(Element element) {
        ThemeElement theme = null;
        for (Element current = element; current != null; current = (Element)current.getParent()) {
            if (!(current instanceof ThemeElement)) continue;
            theme = (ThemeElement)current;
            break;
        }
        return theme;
    }

    public static boolean belongToSameTheme(Element element1, Element element2) {
        return ThemeManager.getThemeOf(element1) == ThemeManager.getThemeOf(element2);
    }

    public static EngineType getEngineByUrl(URL url) {
        if (url == null) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 1) {
            return null;
        }
        String engineName = path[1];
        return (EngineType)Manager.getTypeRegistry().lookup(TypeFamily.ENGINE, engineName);
    }

    public static String getViewModeByUrl(URL url) {
        if (url == null) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 2) {
            return null;
        }
        return path[2];
    }

    public static TemplateEngineType getTemplateEngineByUrl(URL url) {
        if (url == null) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 3) {
            return null;
        }
        String templateEngineName = path[3];
        return (TemplateEngineType)Manager.getTypeRegistry().lookup(TypeFamily.TEMPLATE_ENGINE, templateEngineName);
    }

    public ThemeElement getThemeBySrc(String src) throws ThemeException {
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptor(src);
        if (themeDef.isCustomized()) {
            throw new ThemeException("Cannot access customized theme: " + src);
        }
        String themeName = themeDef.getName();
        return this.getThemeByName(themeName);
    }

    public ThemeElement getThemeByUrl(URL url) {
        String themeName = ThemeManager.getThemeNameByUrl(url);
        if (themeName == null) {
            return null;
        }
        return this.getThemeByName(themeName);
    }

    public static String getThemeNameByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("theme")) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 4) {
            return null;
        }
        return path[4];
    }

    public static String getPagePathByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("theme")) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 5) {
            return null;
        }
        String pagePath = path[4] + '/' + path[5];
        return pagePath;
    }

    public PageElement getThemePageByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("theme")) {
            return null;
        }
        String pagePath = ThemeManager.getPagePathByUrl(url);
        return this.getPageByPath(pagePath);
    }

    public PageElement getPageByPath(String path) {
        return this.pages.get(path);
    }

    public static String getPageNameFromPagePath(String path) {
        if (path.contains("/")) {
            return path.split("/")[1];
        }
        return null;
    }

    public ThemeElement getThemeByName(String name) {
        return this.themes.get(name);
    }

    public void fillScratchPage(String themeName, Element element) throws NodeException, ThemeException {
        String pagePath = String.format("%s/~", themeName);
        PageElement scratchPage = this.getPageByPath(pagePath);
        if (scratchPage != null) {
            ThemeManager.destroyDescendants(scratchPage);
            ThemeManager.removeRelationsOf(scratchPage);
            this.pages.remove(pagePath);
            this.removeOrphanedFormats();
        }
        scratchPage = (PageElement)ElementFactory.create("page");
        Widget pageWidget = (Widget)FormatFactory.create("widget");
        pageWidget.setName("page frame");
        this.registerFormat(pageWidget);
        ElementFormatter.setFormat(scratchPage, pageWidget);
        UidManager uidManager = Manager.getUidManager();
        uidManager.register(scratchPage);
        this.pages.put(pagePath, scratchPage);
        scratchPage.addChild(element);
    }

    public static Element getElementByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("element")) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length < 1) {
            return null;
        }
        String uid = path[path.length - 1];
        return (Element)Manager.getUidManager().getObjectByUid(Integer.valueOf(uid));
    }

    public static PerspectiveType getPerspectiveByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("theme")) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 6) {
            return null;
        }
        String perspectiveName = path[6];
        return (PerspectiveType)Manager.getTypeRegistry().lookup(TypeFamily.PERSPECTIVE, perspectiveName);
    }

    public static String getCollectionNameByUrl(URL url) {
        if (url == null) {
            return null;
        }
        if (!url.getHost().equals("theme")) {
            return null;
        }
        String[] path = url.getPath().split("/");
        if (path.length <= 7) {
            return null;
        }
        String collectionName = path[7];
        return collectionName;
    }

    public static String getUrlDescription(URL url) {
        String[] path = url.getPath().split("/");
        String host = url.getHost();
        String description = "[???]";
        if ("theme".equals(host)) {
            description = String.format("[THEME %s, PAGE %s, ENGINE %s, TEMPLATE %s, PERSPECTIVE %s, MODE %s]", path[4], path[5], path[1], path[3], path[6], path[2]);
        } else if ("element".equals(host)) {
            description = String.format("[ELEMENT %s, ENGINE %s, TEMPLATE %s, MODE %s]", path[4], path[1], path[3], path[2]);
        }
        return description;
    }

    public Identifiable getNamedObject(String themeName, String realm, String name) {
        Map<String, Integer> objectsInTheme = this.namedObjectsByTheme.get(themeName);
        if (objectsInTheme == null) {
            return null;
        }
        Integer uid = objectsInTheme.get(String.format("%s/%s", realm, name));
        if (uid != null) {
            return (Identifiable)Manager.getUidManager().getObjectByUid(uid);
        }
        return null;
    }

    public String getThemeNameOfNamedObject(Identifiable object) {
        return this.themeOfNamedObjects.get(object.getUid());
    }

    public void setNamedObject(String themeName, String realm, Identifiable object) throws ThemeException {
        if (!this.namedObjectsByTheme.containsKey(themeName)) {
            this.namedObjectsByTheme.put(themeName, new LinkedHashMap());
        }
        Integer uid = object.getUid();
        String name = object.getName();
        if (name == null) {
            throw new ThemeException("Cannot register unnamed object, uid: " + uid);
        }
        this.namedObjectsByTheme.get(themeName).put(String.format("%s/%s", realm, name), uid);
        this.themeOfNamedObjects.put(uid, themeName);
    }

    public List<Identifiable> getNamedObjects(String themeName, String realm) {
        ArrayList<Identifiable> objects = new ArrayList<Identifiable>();
        Map<String, Integer> objectsInTheme = this.namedObjectsByTheme.get(themeName);
        String prefix = String.format("%s/", realm);
        UidManager uidManager = Manager.getUidManager();
        if (objectsInTheme != null) {
            for (Map.Entry<String, Integer> entry : objectsInTheme.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                Identifiable object = (Identifiable)uidManager.getObjectByUid(entry.getValue());
                objects.add(object);
            }
        }
        return objects;
    }

    public void removeNamedObject(String themeName, String realm, String name) {
        String key = String.format("%s/%s", realm, name);
        Identifiable object = this.getNamedObject(themeName, realm, name);
        this.themeOfNamedObjects.remove(object.getUid());
        this.namedObjectsByTheme.get(themeName).remove(key);
    }

    public void removeNamedObjects(String themeName) {
        this.namedObjectsByTheme.remove(themeName);
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : this.themeOfNamedObjects.entrySet()) {
            if (!entry.getValue().equals(themeName)) continue;
            toDelete.add(entry.getKey());
        }
        for (Integer key : toDelete) {
            this.themeOfNamedObjects.remove(key);
        }
        toDelete = null;
    }

    public void makeElementUseNamedStyle(Element element, String inheritedName, String themeName) throws ThemeException {
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        Style style = (Style)ElementFormatter.getFormatByType(element, styleType);
        if (style == null) {
            throw new ThemeException("Element has no assigned style: " + element.computeXPath());
        }
        if (inheritedName == null) {
            ThemeManager.removeInheritanceTowards(style);
        } else {
            Style inheritedStyle = (Style)this.getNamedObject(themeName, "style", inheritedName);
            if (inheritedStyle == null) {
                throw new ThemeException("Could not find named style: " + inheritedName);
            }
            this.makeFormatInherit(style, inheritedStyle);
        }
    }

    public static void setStyleInheritance(String styleName, String ancestorStyleName, String themeName, boolean allowMany) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName(themeName);
        if (themeDescriptor == null) {
            throw new ThemeException("Theme not found: " + themeName);
        }
        Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
        if (style == null) {
            throw new ThemeException("Could not find named style: " + styleName);
        }
        Style ancestorStyle = (Style)themeManager.getNamedObject(themeName, "style", ancestorStyleName);
        if (ancestorStyle == null) {
            throw new ThemeException("Could not find named style: " + ancestorStyleName);
        }
        if (!allowMany) {
            ThemeManager.removeInheritanceFrom(ancestorStyle);
        }
        themeManager.makeFormatInherit(style, ancestorStyle);
    }

    public static void loadRemoteStyle(String resourceBankName, Style style) throws ThemeException {
        if (!style.isNamed()) {
            throw new ThemeException("Only named styles can be loaded from resource banks.");
        }
        String styleName = style.getName();
        Matcher resourceNameMatcher = styleResourceNamePattern.matcher(styleName);
        if (!resourceNameMatcher.find()) {
            throw new ThemeException("Incorrect remote style name: " + styleName);
        }
        String collectionName = resourceNameMatcher.group(2);
        String resourceId = resourceNameMatcher.group(1) + ".css";
        String cssSource = ResourceManager.getBankResource(resourceBankName, collectionName, "style", resourceId);
        style.setCollection(collectionName);
        Utils.loadCss(style, cssSource, "*");
    }

    public Element duplicateElement(Element element, boolean duplicateFormats) throws ThemeException {
        Element duplicate;
        String typeName = element.getElementType().getTypeName();
        if (element instanceof Fragment) {
            FragmentType fragmentType = ((Fragment)element).getFragmentType();
            duplicate = FragmentFactory.create(fragmentType.getTypeName());
        } else {
            duplicate = ElementFactory.create(typeName);
        }
        if (duplicate == null) {
            log.warn((Object)("Could not duplicate: " + element));
        } else {
            try {
                FieldIO.updateFieldsFromProperties(duplicate, FieldIO.dumpFieldsToProperties(element));
            }
            catch (Exception e) {
                log.warn((Object)("Could not copy the fields of: " + element));
            }
            for (Format format : ElementFormatter.getFormatsFor(element)) {
                if (duplicateFormats) {
                    format = this.duplicateFormat(format);
                }
                ElementFormatter.setFormat(duplicate, format);
            }
            duplicate.setDescription(element.getDescription());
            PerspectiveManager perspectiveManager = Manager.getPerspectiveManager();
            for (PerspectiveType perspective : perspectiveManager.getPerspectivesFor(element)) {
                PerspectiveManager.setVisibleInPerspective(duplicate, perspective);
            }
        }
        return duplicate;
    }

    public void destroyElement(Element element) throws ThemeException, NodeException {
        Element parent = (Element)element.getParent();
        if (element instanceof ThemeElement) {
            this.removeNamedStylesOf(element.getName());
            this.unregisterTheme((ThemeElement)element);
            ThemeManager.destroyDescendants(element);
            ThemeManager.removeRelationsOf(element);
        } else if (element instanceof PageElement) {
            this.unregisterPage((PageElement)element);
            ThemeManager.destroyDescendants(element);
            ThemeManager.removeRelationsOf(element);
            if (parent != null) {
                parent.removeChild(element);
            }
        } else {
            ThemeManager.destroyDescendants(element);
            ThemeManager.removeRelationsOf(element);
            if (parent != null) {
                parent.removeChild(element);
            }
        }
        this.removeOrphanedFormats();
    }

    public void removeNamedStylesOf(String themeName) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        UidManager uidManager = Manager.getUidManager();
        for (Style style : themeManager.getNamedStyles(themeName)) {
            this.removeNamedObject(themeName, "style", style.getName());
            this.deleteFormat(style);
            uidManager.unregister(style);
        }
    }

    public Format duplicateFormat(Format format) throws ThemeException {
        String typeName = format.getFormatType().getTypeName();
        Format duplicate = FormatFactory.create(typeName);
        this.registerFormat(duplicate);
        duplicate.setName(format.getName());
        duplicate.setDescription(format.getDescription());
        duplicate.clonePropertiesOf(format);
        Format ancestor = ThemeManager.getAncestorFormatOf(format);
        if (ancestor != null) {
            this.makeFormatInherit(duplicate, ancestor);
        }
        return duplicate;
    }

    public List<Format> listFormats() {
        UidManager uidManager = Manager.getUidManager();
        ArrayList<Format> formats = new ArrayList<Format>();
        for (Map.Entry<String, List<Integer>> entry : this.formatsByTypeName.entrySet()) {
            for (Integer uid : entry.getValue()) {
                Format format = (Format)uidManager.getObjectByUid(uid);
                formats.add(format);
            }
        }
        return formats;
    }

    public void registerFormat(Format format) throws ThemeException {
        List<Integer> ids;
        Integer id = format.getUid();
        if (id == null) {
            throw new ThemeException("Cannot register a format without an id");
        }
        String formatTypeName = format.getFormatType().getTypeName();
        if (formatTypeName == null) {
            throw new ThemeException("Cannot register a format without a type");
        }
        if (!this.formatsByTypeName.containsKey(formatTypeName)) {
            this.formatsByTypeName.put(formatTypeName, new ArrayList());
        }
        if ((ids = this.formatsByTypeName.get(formatTypeName)).contains(id)) {
            throw new ThemeException("Cannot register a format twice: " + id);
        }
        ids.add(id);
    }

    public void unregisterFormat(Format format) throws ThemeException {
        Integer id = format.getUid();
        if (id == null) {
            throw new ThemeException("Cannot unregister a format without an id");
        }
        String formatTypeName = format.getFormatType().getTypeName();
        if (formatTypeName == null) {
            throw new ThemeException("Cannot unregister a format without a type");
        }
        if (this.formatsByTypeName.containsKey(formatTypeName)) {
            List<Integer> ids = this.formatsByTypeName.get(formatTypeName);
            if (!ids.contains(id)) {
                throw new ThemeException("Format with id: " + id + " is not registered.");
            }
            ids.remove(id);
        }
        ThemeManager.removeInheritanceTowards(format);
        ThemeManager.removeInheritanceFrom(format);
    }

    public Set<String> getFormatTypeNames() {
        return new LinkedHashSet<String>(this.formatsByTypeName.keySet());
    }

    public List<Format> getFormatsByTypeName(String formatTypeName) {
        ArrayList<Format> formats = new ArrayList<Format>();
        if (!this.formatsByTypeName.containsKey(formatTypeName)) {
            return formats;
        }
        UidManager uidManager = Manager.getUidManager();
        for (Integer id : this.formatsByTypeName.get(formatTypeName)) {
            formats.add((Format)uidManager.getObjectByUid(id));
        }
        return formats;
    }

    public List<Style> getStyles() {
        return this.getStyles(null);
    }

    public List<Style> getStyles(String themeName) {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Format format : this.getFormatsByTypeName("style")) {
            Style style = (Style)format;
            if (themeName != null) {
                ThemeElement theme = ThemeManager.getThemeOfFormat(style);
                if (theme == null) {
                    if (style.isNamed()) continue;
                    log.warn((Object)("THEME inconsistency: " + style + " is not associated to any element."));
                    continue;
                }
                if (!themeName.equals(theme.getName())) continue;
            }
            styles.add(style);
        }
        return styles;
    }

    public List<Style> getNamedStyles(String themeName) {
        ArrayList<Style> styles = new ArrayList<Style>();
        if (themeName != null) {
            for (Identifiable object : this.getNamedObjects(themeName, "style")) {
                if (!(object instanceof Style)) {
                    log.error((Object)("Expected Style object, got instead " + object));
                    continue;
                }
                styles.add((Style)object);
            }
        }
        return styles;
    }

    public List<Style> getSortedNamedStyles(String themeName) {
        List<Style> namedStyles = this.getNamedStyles(themeName);
        DAG graph = new DAG();
        for (Style s : namedStyles) {
            String styleName = s.getName();
            graph.addVertex(styleName);
            for (Format f : ThemeManager.listFormatsDirectlyInheritingFrom(s)) {
                if (!f.isNamed()) continue;
                try {
                    graph.addEdge(styleName, f.getName());
                }
                catch (CycleDetectedException e) {
                    log.error((Object)"Cycle detected in style dependencies: ", (Throwable)e);
                    return namedStyles;
                }
            }
        }
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Object name : TopologicalSorter.sort((DAG)graph)) {
            styles.add((Style)this.getNamedObject(themeName, "style", (String)name));
        }
        return styles;
    }

    public Long getLastModified(String themeName) {
        Long date = this.lastModified.get(themeName);
        if (date == null) {
            return 0L;
        }
        return date;
    }

    public void setLastModified(String themeName, Long date) {
        this.lastModified.put(themeName, date);
    }

    public Long getLastModified(URL url) {
        String themeName = ThemeManager.getThemeNameByUrl(url);
        return this.getLastModified(themeName);
    }

    public void themeModified(String themeName) {
        this.setLastModified(themeName, new Date().getTime());
        Manager.getResourceManager().clearGlobalCache(themeName);
    }

    public void stylesModified(String themeName) {
        this.resetCachedStyles(themeName);
    }

    public void resetCachedResources() {
        this.cachedResources.clear();
    }

    public void registerTheme(ThemeElement theme) {
        String themeName = theme.getName();
        this.themes.put(themeName, theme);
        for (Node node : theme.getChildren()) {
            PageElement page = (PageElement)node;
            String pagePath = String.format("%s/%s", themeName, page.getName());
            this.pages.put(pagePath, page);
        }
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.sendEvent(new Event(THEME_TOPIC, THEME_REGISTERED_EVENT_ID, (Object)this, (Object)themeName));
        this.themeModified(themeName);
        this.stylesModified(themeName);
    }

    public void registerPage(ThemeElement theme, PageElement page) throws NodeException {
        theme.addChild(page);
        String themeName = theme.getName();
        String pageName = page.getName();
        this.pages.put(String.format("%s/%s", themeName, pageName), page);
        log.debug((Object)("Added page: " + pageName + " to theme: " + themeName));
    }

    public void unregisterTheme(ThemeElement theme) {
        String themeName = theme.getName();
        for (PageElement page : ThemeManager.getPagesOf(theme)) {
            this.unregisterPage(page);
        }
        this.themes.remove(themeName);
        log.debug((Object)("Removed theme: " + themeName));
    }

    public void unregisterPage(PageElement page) {
        ThemeElement theme = (ThemeElement)page.getParent();
        if (theme == null) {
            log.debug((Object)("Page has no parent: " + page.getUid()));
            return;
        }
        String themeName = theme.getName();
        String pageName = page.getName();
        this.pages.remove(String.format("%s/%s", themeName, pageName));
        log.debug((Object)("Removed page: " + pageName + " from theme: " + themeName));
    }

    public static void loadTheme(ThemeDescriptor themeDescriptor) {
        themeDescriptor.setLoadingFailed(true);
        String src = themeDescriptor.getSrc();
        if (src == null) {
            log.error((Object)"Could not load theme, source not set. ");
            return;
        }
        try {
            boolean preload = false;
            ThemeParser.registerTheme(themeDescriptor, false);
            themeDescriptor.setLoadingFailed(false);
        }
        catch (ThemeIOException e) {
            log.error((Object)("Could not register theme: " + src + " " + e.getMessage()));
        }
    }

    public void loadTheme(String src, String xmlSource) throws ThemeIOException, ThemeException {
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor(src);
        if (themeDescriptor == null) {
            throw new ThemeIOException("Theme not found: " + src);
        }
        String oldThemeName = themeDescriptor.getName();
        themeDescriptor.setLoadingFailed(true);
        boolean preload = false;
        ThemeParser.registerTheme(themeDescriptor, xmlSource, false);
        String themeName = themeDescriptor.getName();
        themeDescriptor.setName(themeName);
        this.themeModified(themeName);
        this.stylesModified(themeName);
        ThemeManager.updateThemeDescriptors();
        if (!themeName.equals(oldThemeName)) {
            this.themes.remove(oldThemeName);
            for (ThemeDescriptor themeDef : ThemeManager.getThemeDescriptors()) {
                if (!oldThemeName.equals(themeDef.getName()) || themeDef.isCustomized()) continue;
                this.loadTheme(themeDef.getSrc());
            }
        }
    }

    public void loadTheme(String src) throws ThemeIOException, ThemeException {
        this.loadTheme(src, null);
    }

    public void deleteTheme(String src) throws ThemeIOException, ThemeException {
        String themeName;
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor(src);
        if (themeDescriptor.isXmlConfigured()) {
            throw new ThemeIOException("Themes registered as contributions cannot be deleted: " + src);
        }
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeElement theme = themeManager.getThemeByName(themeName = themeDescriptor.getName());
        if (theme == null) {
            throw new ThemeIOException("Theme not found: " + themeName);
        }
        URL url = null;
        try {
            url = new URL(src);
        }
        catch (MalformedURLException e) {
            throw new ThemeIOException(e);
        }
        if (!url.getProtocol().equals("file")) {
            throw new ThemeIOException("Theme source is not that of a file: " + src);
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            throw new ThemeIOException("File not found: " + src);
        }
        String themeFileName = String.format("theme-%s.bak", themeName);
        File backupFile = new File(ThemeManager.getThemeDir(), themeFileName);
        if (backupFile.exists() && !backupFile.delete()) {
            throw new ThemeIOException("Error while deleting backup file: " + backupFile.getPath());
        }
        if (!file.renameTo(backupFile)) {
            throw new ThemeIOException("Error while creating backup file: " + backupFile.getPath());
        }
        try {
            themeManager.destroyElement(theme);
        }
        catch (NodeException e) {
            throw new ThemeIOException("Failed to delete theme: " + themeName, e);
        }
        catch (ThemeException e) {
            throw new ThemeIOException("Failed to delete theme: " + themeName, e);
        }
        this.themes.remove(themeName);
        ThemeManager.deleteThemeDescriptor(src);
        ThemeManager.updateThemeDescriptors();
        for (ThemeDescriptor themeDef : ThemeManager.getThemeDescriptors()) {
            if (!themeName.equals(themeDef.getName()) || themeDef.isCustomized()) continue;
            this.loadTheme(themeDef.getSrc());
        }
    }

    public void deletePage(String path) throws ThemeIOException, ThemeException {
        PageElement page = this.getPageByPath(path);
        if (page == null) {
            throw new ThemeIOException("Failed to delete unkown page: " + path);
        }
        try {
            this.destroyElement(page);
        }
        catch (NodeException e) {
            throw new ThemeIOException("Failed to delete page: " + path, e);
        }
    }

    public static void saveTheme(String src) throws ThemeIOException, ThemeException {
        ThemeManager.saveTheme(src, 2);
    }

    public static void saveTheme(String src, int indent) throws ThemeIOException, ThemeException {
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor(src);
        if (themeDescriptor == null) {
            throw new ThemeIOException("Theme not found: " + src);
        }
        if (!themeDescriptor.isWritable()) {
            throw new ThemeIOException("Protocol does not support output: " + src);
        }
        ThemeSerializer serializer = new ThemeSerializer();
        String xml = serializer.serializeToXml(src, indent);
        URL url = null;
        try {
            url = new URL(src);
        }
        catch (MalformedURLException e) {
            throw new ThemeIOException("Could not save theme to " + src, e);
        }
        try {
            Utils.writeFile(url, xml);
        }
        catch (IOException e) {
            throw new ThemeIOException("Could not save theme to " + src, e);
        }
        themeDescriptor.setLastSaved(new Date());
        log.debug((Object)("Saved theme: " + src));
    }

    public static void repairTheme(ThemeElement theme) throws ThemeIOException {
        try {
            ThemeRepairer.repair(theme);
        }
        catch (ThemeException e) {
            throw new ThemeIOException("Could not repair theme: " + theme.getName(), e);
        }
        log.debug((Object)("Repaired theme: " + theme.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String renderElement(URL url) throws ThemeException {
        String result = null;
        InputStream is = null;
        try {
            is = url.openStream();
            try (Reader in = null;){
                int ch;
                in = new BufferedReader(new InputStreamReader(is));
                StringBuilder rendered = new StringBuilder();
                while ((ch = in.read()) > -1) {
                    rendered.append((char)ch);
                }
                result = rendered.toString();
                return result;
            }
        }
        catch (IOException e) {
            throw new ThemeException(e);
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    public void removeOrphanedFormats() throws ThemeException {
        UidManager uidManager = Manager.getUidManager();
        for (Format format : this.listFormats()) {
            if (format.isNamed() || !ElementFormatter.getElementsFor(format).isEmpty()) continue;
            this.deleteFormat(format);
            uidManager.unregister(format);
        }
    }

    private static void removeRelationsOf(Element element) {
        UidManager uidManager = Manager.getUidManager();
        PerspectiveManager perspectiveManager = Manager.getPerspectiveManager();
        for (Format format : ElementFormatter.getFormatsFor(element)) {
            ElementFormatter.removeFormat(element, format);
        }
        perspectiveManager.setAlwaysVisible(element);
        uidManager.unregister(element);
    }

    private static void destroyDescendants(Element element) throws NodeException {
        for (Node node : element.getDescendants()) {
            ThemeManager.removeRelationsOf((Element)node);
        }
        element.removeDescendants();
    }

    public void makeFormatInherit(Format format, Format ancestor) {
        if (format.equals(ancestor)) {
            FormatType formatType = format.getFormatType();
            String formatName = formatType != null ? formatType.getTypeName() : "unknown";
            log.error((Object)String.format("A format ('%s' with type '%s') cannot inherit from itself, aborting", format.getName(), formatName));
            return;
        }
        if (ThemeManager.listAncestorFormatsOf(ancestor).contains(format)) {
            log.error((Object)"Cycle detected.in format inheritance, aborting.");
            return;
        }
        ThemeManager.removeInheritanceTowards(format);
        DyadicRelation relation = new DyadicRelation(PREDICATE_FORMAT_INHERIT, format, ancestor);
        Manager.getRelationStorage().add(relation);
    }

    public static void removeInheritanceTowards(Format descendant) {
        Collection<Relation> relations = Manager.getRelationStorage().search(PREDICATE_FORMAT_INHERIT, descendant, null);
        for (Relation relation : relations) {
            Manager.getRelationStorage().remove(relation);
        }
    }

    public static void removeInheritanceFrom(Format ancestor) {
        Collection<Relation> relations = Manager.getRelationStorage().search(PREDICATE_FORMAT_INHERIT, null, ancestor);
        for (Relation relation : relations) {
            Manager.getRelationStorage().remove(relation);
        }
    }

    public static Format getAncestorFormatOf(Format format) {
        Collection<Relation> relations = Manager.getRelationStorage().search(PREDICATE_FORMAT_INHERIT, format, null);
        Iterator<Relation> it = relations.iterator();
        if (it.hasNext()) {
            return (Format)it.next().getRelate(2);
        }
        return null;
    }

    public static List<Format> listAncestorFormatsOf(Format format) {
        ArrayList<Format> ancestors = new ArrayList<Format>();
        Format current = format;
        while (current != null && (current = ThemeManager.getAncestorFormatOf(current)) != null && !ancestors.contains(current)) {
            ancestors.add(current);
        }
        return ancestors;
    }

    public static List<Format> listFormatsDirectlyInheritingFrom(Format format) {
        ArrayList<Format> formats = new ArrayList<Format>();
        Collection<Relation> relations = Manager.getRelationStorage().search(PREDICATE_FORMAT_INHERIT, null, format);
        Iterator<Relation> it = relations.iterator();
        while (it.hasNext()) {
            formats.add((Format)it.next().getRelate(1));
        }
        return formats;
    }

    public void deleteFormat(Format format) throws ThemeException {
        ThemeManager.removeInheritanceTowards(format);
        ThemeManager.removeInheritanceFrom(format);
        this.unregisterFormat(format);
    }

    public static List<String> getUnusedStyleViews(Style style) {
        ArrayList<String> views = new ArrayList<String>();
        if (style.isNamed()) {
            return views;
        }
        for (Element element : ElementFormatter.getElementsFor(style)) {
            Widget widget = (Widget)ElementFormatter.getFormatFor(element, "widget");
            String viewName = widget.getName();
            for (String name : style.getSelectorViewNames()) {
                if (name.equals(viewName)) continue;
                views.add(name);
            }
        }
        return views;
    }

    public String getCachedStyles(String themeName, String basePath, String collectionName) {
        String key = String.format("%s|%s|%s", themeName, basePath != null ? basePath : "", collectionName != null ? collectionName : "");
        return this.cachedStyles.get(key);
    }

    public synchronized void setCachedStyles(String themeName, String basePath, String collectionName, String css) {
        String key = String.format("%s|%s|%s", themeName, basePath != null ? basePath : "", collectionName != null ? collectionName : "");
        this.cachedStyles.put(key, css);
    }

    private synchronized void resetCachedStyles(String themeName) {
        for (String key : this.cachedStyles.keySet()) {
            if (!key.startsWith(themeName)) continue;
            this.cachedStyles.put(key, null);
        }
    }

    public String getResource(String name) {
        return this.cachedResources.get(name);
    }

    public synchronized void setResource(String name, String content) {
        this.cachedResources.put(name, content);
    }

    public synchronized void updateResourceOrdering() {
        DAG graph = new DAG();
        for (Type type : Manager.getTypeRegistry().getTypes(TypeFamily.RESOURCE)) {
            ResourceType resourceType = (ResourceType)type;
            String resourceName = resourceType.getName();
            graph.addVertex(resourceName);
            for (String dependency : resourceType.getDependencies()) {
                try {
                    graph.addEdge(resourceName, dependency);
                }
                catch (CycleDetectedException e) {
                    log.error((Object)"Cycle detected in resource dependencies: ", (Throwable)e);
                    return;
                }
            }
        }
        this.resourceOrdering.clear();
        for (Type r : TopologicalSorter.sort((DAG)graph)) {
            this.resourceOrdering.add((String)((Object)r));
        }
    }

    public List<String> getResourceOrdering() {
        return this.resourceOrdering;
    }

    public List<String> getOrderedResourcesAndDeps(List<String> resourceNames) {
        ArrayList<String> res = new ArrayList<String>();
        if (resourceNames == null) {
            return res;
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (String resourceName : resourceNames) {
            ResourceType resource = (ResourceType)typeRegistry.lookup(TypeFamily.RESOURCE, resourceName);
            if (resource == null) {
                log.error((Object)String.format("Resource not registered %s.", resourceName));
                continue;
            }
            String[] deps = resource.getDependencies();
            if (deps != null) {
                for (String dep : deps) {
                    res.add(dep);
                }
            }
            res.add(resourceName);
        }
        ArrayList<String> orderedRes = new ArrayList<String>();
        List<String> ordered = this.getResourceOrdering();
        if (ordered != null) {
            for (String resource : ordered) {
                if (!res.contains(resource)) continue;
                orderedRes.add(resource);
            }
        }
        return orderedRes;
    }

    public void unregisterResourceOrdering(ResourceType resourceType) {
        String resourceName = resourceType.getName();
        if (this.resourceOrdering.contains(resourceName)) {
            this.resourceOrdering.remove(resourceName);
        }
    }

    public byte[] getImageResource(String path) throws ThemeException {
        String key = String.format("image/%s", path);
        byte[] data = this.cachedBinaries.get(key);
        if (data == null) {
            String[] parts = path.split("/");
            if (parts.length != 3) {
                throw new ThemeException("Incorrect image path: " + path);
            }
            String resourceBankName = parts[0];
            String collectionName = parts[1];
            String resourceName = parts[2];
            data = ResourceManager.getBinaryBankResource(resourceBankName, collectionName, "image", resourceName);
            this.cachedBinaries.put(key, data);
        }
        return data;
    }

    public static List<ViewType> getViewTypesForFragmentType(FragmentType fragmentType) {
        ArrayList<ViewType> viewTypes = new ArrayList<ViewType>();
        for (Type v : Manager.getTypeRegistry().getTypes(TypeFamily.VIEW)) {
            ElementType elementType;
            ViewType viewType = (ViewType)v;
            String viewName = viewType.getViewName();
            if ("*".equals(viewName) || (elementType = viewType.getElementType()) != null && !elementType.getTypeName().equals("fragment") || !viewType.getFormatType().getTypeName().equals("widget")) continue;
            ModelType modelType = viewType.getModelType();
            if (fragmentType.getModelType() != modelType) continue;
            viewTypes.add(viewType);
        }
        return viewTypes;
    }

    public static ResourceBank getResourceBank(String name) throws ThemeException {
        if (name == null) {
            throw new ThemeException("Resource bank name not set");
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ResourceBank resourceBank = (ResourceBank)typeRegistry.lookup(TypeFamily.RESOURCE_BANK, name);
        if (resourceBank != null) {
            return resourceBank;
        }
        throw new ThemeException("Resource bank not found: " + name);
    }

    public static List<ResourceBank> getResourceBanks() {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ArrayList<ResourceBank> resourceBanks = new ArrayList<ResourceBank>();
        for (Type type : typeRegistry.getTypes(TypeFamily.RESOURCE_BANK)) {
            resourceBanks.add((ResourceBank)type);
        }
        return resourceBanks;
    }

    public static List<ThemeDescriptor> getThemeDescriptors() {
        ArrayList<ThemeDescriptor> themeDescriptors = new ArrayList<ThemeDescriptor>();
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (Type type : typeRegistry.getTypes(TypeFamily.THEME)) {
            if (type == null) continue;
            ThemeDescriptor themeDescriptor = (ThemeDescriptor)type;
            themeDescriptors.add(themeDescriptor);
        }
        return themeDescriptors;
    }

    public static ThemeDescriptor getThemeDescriptor(String src) throws ThemeException {
        ThemeDescriptor themeDef = (ThemeDescriptor)Manager.getTypeRegistry().lookup(TypeFamily.THEME, src);
        if (themeDef == null) {
            throw new ThemeException("Unknown theme: " + src);
        }
        return themeDef;
    }

    public static void deleteThemeDescriptor(String src) throws ThemeException {
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptor(src);
        Manager.getTypeRegistry().unregister(themeDef);
    }

    public static List<String> getTemplateEngineNames() {
        ArrayList<String> types = new ArrayList<String>();
        for (Type type : Manager.getTypeRegistry().getTypes(TypeFamily.TEMPLATE_ENGINE)) {
            types.add(type.getTypeName());
        }
        return types;
    }

    public static String getTemplateEngineName(String applicationPath) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        if (applicationPath == null) {
            return ThemeManager.getDefaultTemplateEngineName();
        }
        ApplicationType application = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, applicationPath);
        if (application != null) {
            return application.getTemplateEngine();
        }
        return ThemeManager.getDefaultTemplateEngineName();
    }

    public static String getDefaultTemplateEngineName() {
        return "jsf-facelets";
    }

    public static Element getElementById(Integer id) {
        Object object = Manager.getUidManager().getObjectByUid(id);
        if (!(object instanceof Element)) {
            return null;
        }
        return (Element)object;
    }

    public static Element getElementById(String id) {
        return ThemeManager.getElementById(Integer.valueOf(id));
    }

    public static Format getFormatById(Integer id) {
        Object object = Manager.getUidManager().getObjectByUid(id);
        if (!(object instanceof Format)) {
            return null;
        }
        return (Format)object;
    }

    public static Format getFormatById(String id) {
        return ThemeManager.getFormatById(Integer.valueOf(id));
    }

    public static ThemeElement getThemeOfFormat(Format format) {
        Collection<Element> elements = ElementFormatter.getElementsFor(format);
        if (elements.isEmpty()) {
            return null;
        }
        Element element = elements.iterator().next();
        return ThemeManager.getThemeOf(element);
    }

    public Layout createLayout() {
        Layout layout = null;
        try {
            layout = (Layout)FormatFactory.create("layout");
            this.registerFormat(layout);
        }
        catch (ThemeException e) {
            log.error((Object)"Layout creation failed", (Throwable)e);
        }
        return layout;
    }

    public Widget createWidget() {
        Widget widget = null;
        try {
            widget = (Widget)FormatFactory.create("widget");
            this.registerFormat(widget);
        }
        catch (ThemeException e) {
            log.error((Object)"Widget creation failed", (Throwable)e);
        }
        return widget;
    }

    public Style createStyle() {
        Style style = null;
        try {
            style = (Style)FormatFactory.create("style");
            this.registerFormat(style);
        }
        catch (ThemeException e) {
            log.error((Object)"Style creation failed", (Throwable)e);
        }
        return style;
    }

    public void registerModelByClassname(ModelType modelType) {
        this.modelsByClassname.put(modelType.getClassName(), modelType);
    }

    public void unregisterModelByClassname(ModelType modelType) {
        this.modelsByClassname.remove(modelType.getClassName());
    }

    public ModelType getModelByClassname(String className) {
        return this.modelsByClassname.get(className);
    }

    public List<ThemeSet> getThemeSets() {
        ArrayList<ThemeSet> themeSets = new ArrayList<ThemeSet>();
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (Type type : typeRegistry.getTypes(TypeFamily.THEMESET)) {
            themeSets.add((ThemeSet)type);
        }
        return themeSets;
    }

    public ThemeSet getThemeSetByName(String name) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        return (ThemeSet)typeRegistry.lookup(TypeFamily.THEMESET, name);
    }

    public static String getCollectionCssMarker() {
        return COLLECTION_CSS_MARKER;
    }

    static {
        CUSTOM_THEME_FILENAME_FILTER = new CustomThemeNameFilter();
        styleResourceNamePattern = Pattern.compile("(.*?)\\s\\((.*?)\\)$", 32);
    }
}

