/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaExpression;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CSSMediaQuery
implements ICSSWriteable {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final List<CSSMediaExpression> m_aMediaExpressions = new ArrayList<CSSMediaExpression>();

    public CSSMediaQuery(@Nonnull EModifier eModifier, @Nullable String string) {
        if (eModifier == null) {
            throw new NullPointerException("modifier");
        }
        this.m_eModifier = eModifier;
        this.m_sMedium = string;
    }

    public boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    @Nullable
    public String getMedium() {
        return this.m_sMedium;
    }

    public boolean hasMediaExpressions() {
        return !this.m_aMediaExpressions.isEmpty();
    }

    @Nonnegative
    public int getMediaExpressionCount() {
        return this.m_aMediaExpressions.size();
    }

    public void addMediaExpression(@Nonnull CSSMediaExpression cSSMediaExpression) {
        if (cSSMediaExpression == null) {
            throw new NullPointerException("expression");
        }
        this.m_aMediaExpressions.add(cSSMediaExpression);
    }

    public void addMediaExpression(@Nonnegative int n, @Nonnull CSSMediaExpression cSSMediaExpression) {
        if (cSSMediaExpression == null) {
            throw new NullPointerException("expression");
        }
        this.m_aMediaExpressions.add(n, cSSMediaExpression);
    }

    @Nonnull
    public EChange removeMediaExpression(@Nonnull CSSMediaExpression cSSMediaExpression) {
        return EChange.valueOf((boolean)this.m_aMediaExpressions.remove(cSSMediaExpression));
    }

    @Nonnull
    public EChange removeMediaExpression(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaExpressions.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aMediaExpressions.remove(n) != null ? 1 : 0) != 0);
    }

    @Nullable
    public CSSMediaExpression getMediaExpression(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaExpressions.size()) {
            return null;
        }
        return this.m_aMediaExpressions.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaExpression> getAllMediaExpressions() {
        return ContainerHelper.newList(this.m_aMediaExpressions);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_eModifier.getCSSText());
        boolean bl = true;
        if (this.m_sMedium != null) {
            stringBuilder.append(this.m_sMedium);
            bl = false;
        }
        if (!this.m_aMediaExpressions.isEmpty()) {
            for (CSSMediaExpression cSSMediaExpression : this.m_aMediaExpressions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(cSSMediaExpression.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSMediaQuery)) {
            return false;
        }
        CSSMediaQuery cSSMediaQuery = (CSSMediaQuery)object;
        return this.m_eModifier.equals((Object)cSSMediaQuery.m_eModifier) && EqualsUtils.equals((Object)this.m_sMedium, (Object)cSSMediaQuery.m_sMedium) && ((Object)this.m_aMediaExpressions).equals(cSSMediaQuery.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("modifier", (Enum)this.m_eModifier).append("medium", (Object)this.m_sMedium).append("expressions", this.m_aMediaExpressions).toString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String string2) {
            this.m_sText = string2;
        }

        @Nonnull
        public String getCSSText() {
            return this.m_sText;
        }
    }
}

