/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class PrefetchInfo
implements Serializable {
    private static final long serialVersionUID = -6495547095819614741L;
    private static final Log log = LogFactory.getLog(PrefetchInfo.class);
    private final String expr;
    private transient String[] fields;
    private transient String[] schemas;
    private static final Pattern STAR_OR_DIGITS = Pattern.compile("\\*|(\\d+)");

    public PrefetchInfo(String expr) {
        this.expr = expr;
    }

    public String[] getSchemas() {
        this.parseExpression();
        return this.schemas;
    }

    public String[] getFields() {
        this.parseExpression();
        return this.fields;
    }

    private void parseExpression() {
        if (this.fields != null || this.expr == null) {
            return;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> schemas = new ArrayList<String>();
        for (String s : this.expr.split("[ \t\n\r,]")) {
            Field field;
            if (s.isEmpty()) continue;
            Schema schema = schemaManager.getSchema(s = ComplexTypeImpl.canonicalXPath(s));
            if (schema != null) {
                schemas.add(s);
                continue;
            }
            String[] props = s.split("/");
            if (props.length == 0) continue;
            String prop = props[0];
            List<String> complex = Arrays.asList(props).subList(1, props.length);
            LinkedList<String> parts = new LinkedList<String>();
            int i = prop.indexOf(46);
            if (i != -1) {
                String schemaName = prop.substring(0, i);
                String fieldName = prop.substring(i + 1);
                schema = schemaManager.getSchema(schemaName);
                field = schema == null ? null : schema.getField(fieldName);
            } else {
                field = schemaManager.getField(prop);
            }
            if (field == null) {
                PrefetchInfo.logNotFound(s);
                continue;
            }
            parts.add(field.getName().getPrefixedName());
            for (String t : complex) {
                Type fieldType = field.getType();
                if (fieldType.isComplexType()) {
                    ComplexType fieldComplexType = (ComplexType)fieldType;
                    field = fieldComplexType.getField(t);
                    parts.add(t);
                    continue;
                }
                if (fieldType.isListType()) {
                    ListType listType = (ListType)fieldType;
                    if (!listType.getFieldType().isSimpleType()) {
                        if (!STAR_OR_DIGITS.matcher(t).matches()) {
                            field = null;
                            break;
                        }
                        field = listType.getField();
                        parts.add("*");
                        continue;
                    }
                    field = null;
                    break;
                }
                field = null;
                break;
            }
            if (field == null) {
                PrefetchInfo.logNotFound(s);
                continue;
            }
            if (!PrefetchInfo.isScalarField(field)) {
                log.error((Object)("Prefetch field '" + s + "' is not scalar"));
                continue;
            }
            fields.add(StringUtils.join(parts, (char)'/'));
        }
        this.fields = fields.toArray(new String[fields.size()]);
        this.schemas = schemas.toArray(new String[schemas.size()]);
    }

    private static boolean isScalarField(Field field) {
        Type fieldType = field.getType();
        if (fieldType.isComplexType()) {
            return false;
        }
        if (!fieldType.isListType()) {
            return true;
        }
        return ((ListType)fieldType).getFieldType().isSimpleType();
    }

    private static void logNotFound(String s) {
        log.error((Object)("Prefetch field or schema '" + s + "' not found"));
    }
}

