/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingServletOutputStream;
import org.nuxeo.ecm.webengine.WebException;

@Provider
@Produces(value={"*/*", "text/plain"})
public class BlobWriter
implements MessageBodyWriter<Blob> {
    public void writeTo(Blob t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            BufferingServletOutputStream.stopBufferingThread();
            t.transferTo(entityStream);
            entityStream.flush();
        }
        catch (Throwable e) {
            throw WebException.wrap("Failed to render resource", e);
        }
    }

    public long getSize(Blob arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.getLength();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return Blob.class.isAssignableFrom(arg0);
    }
}

