/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryResultImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryStatementImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoBinding;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;

public class NuxeoSession
implements Session {
    private static final long serialVersionUID = 1L;
    public static final OperationContext DEFAULT_CONTEXT = new OperationContextImpl(null, false, true, false, IncludeRelationships.NONE, null, true, null, true, 10);
    private final CoreSession coreSession;
    private final String repositoryId;
    protected final NuxeoObjectFactory objectFactory;
    private final NuxeoCmisService service;
    private final NuxeoBinding binding;
    private OperationContext defaultContext = DEFAULT_CONTEXT;

    public NuxeoSession(CoreSession coreSession, NuxeoRepository repository, CallContext context) {
        this.coreSession = coreSession;
        this.repositoryId = repository.getId();
        this.objectFactory = new NuxeoObjectFactory(this);
        this.service = new NuxeoCmisService(repository, context, coreSession);
        this.binding = new NuxeoBinding(this.service);
    }

    public NuxeoObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public NuxeoBinding getBinding() {
        return this.binding;
    }

    public NuxeoCmisService getService() {
        return this.service;
    }

    protected CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void clear() {
    }

    public void save() {
        try {
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void setDefaultContext(OperationContext defaultContext) {
        this.defaultContext = defaultContext;
    }

    public OperationContext getDefaultContext() {
        return this.defaultContext;
    }

    protected String getRepositoryId() {
        return this.coreSession.getRepositoryName();
    }

    public ObjectId createObjectId(String id) {
        return new ObjectIdImpl(id);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    protected Properties convertProperties(Map<String, ?> properties) {
        if (properties == null) {
            return null;
        }
        String typeId = (String)properties.get("cmis:objectTypeId");
        if (typeId == null) {
            throw new IllegalArgumentException("Missing type");
        }
        ObjectType type = this.getTypeDefinition(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + typeId);
        }
        return this.objectFactory.convertProperties(properties, type, null, null);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        String id = this.service.createDocument(this.repositoryId, this.convertProperties(properties), folderId == null ? null : folderId.getId(), contentStream, versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        return this.createObjectId(id);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        String id = this.service.createFolder(this.repositoryId, this.convertProperties(properties), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        return this.createObjectId(id);
    }

    public OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    public ObjectId createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        String id = this.service.createRelationship(this.repositoryId, this.convertProperties(properties), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        return this.createObjectId(id);
    }

    public ObjectId createItem(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new CmisNotSupportedException();
    }

    public ObjectId createItem(Map<String, ?> properties, ObjectId folderId) {
        throw new CmisNotSupportedException();
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems) {
        return this.getContentChanges(changeLogToken, includeProperties, maxNumItems, this.getDefaultContext());
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public CmisObject getObject(ObjectId objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(String objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(DocumentModel doc, OperationContext context) {
        NuxeoObjectData data = new NuxeoObjectData(this.service, doc, context);
        return this.objectFactory.convertObject(data, context);
    }

    public CmisObject getObject(ObjectId objectId, OperationContext context) {
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        return this.getObject(objectId.getId(), context);
    }

    public CmisObject getObject(String objectId, OperationContext context) {
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        if (context == null) {
            throw new CmisInvalidArgumentException("Missing operation context");
        }
        NuxeoObjectData data = this.service.getObject(this.repositoryId, objectId, context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
        return this.objectFactory.convertObject(data, context);
    }

    public CmisObject getObjectByPath(String path) {
        return this.getObjectByPath(path, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String path, OperationContext context) {
        if (path == null || !path.startsWith("/")) {
            throw new CmisInvalidArgumentException("Invalid path: " + path);
        }
        if (context == null) {
            throw new CmisInvalidArgumentException("Missing operation context");
        }
        ObjectData data = this.service.getObjectByPath(this.repositoryId, path, context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
        return this.getObjectFactory().convertObject(data, context);
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.service.getRepositoryInfo(this.repositoryId, null);
    }

    public Folder getRootFolder() {
        return this.getRootFolder(this.getDefaultContext());
    }

    public Folder getRootFolder(OperationContext context) {
        String id = this.getRepositoryInfo().getRootFolderId();
        CmisObject folder = this.getObject(this.createObjectId(id), context);
        if (!(folder instanceof Folder)) {
            throw new CmisRuntimeException("Root object is not a Folder but: " + folder.getClass().getName());
        }
        return (Folder)folder;
    }

    public ItemIterable<ObjectType> getTypeChildren(String typeId, boolean includePropertyDefinitions) {
        throw new UnsupportedOperationException();
    }

    public ObjectType getTypeDefinition(String typeId) {
        TypeDefinition typeDefinition = this.service.getTypeDefinition(this.repositoryId, typeId, null);
        return this.objectFactory.convertTypeDefinition(typeDefinition);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<QueryResult> query(final String statement, final boolean searchAllVersions, final OperationContext context) {
        AbstractPageFetcher<QueryResult> pageFetcher = new AbstractPageFetcher<QueryResult>((long)context.getMaxItemsPerPage()){

            protected AbstractPageFetcher.Page<QueryResult> fetchPage(long skipCount) {
                ObjectList results = NuxeoSession.this.service.query(NuxeoSession.this.repositoryId, statement, searchAllVersions, context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<QueryResultImpl> page = new ArrayList<QueryResultImpl>();
                if (results.getObjects() != null) {
                    for (ObjectData data : results.getObjects()) {
                        page.add(new QueryResultImpl((Session)NuxeoSession.this, data));
                    }
                }
                return new AbstractPageFetcher.Page(page, results.getNumItems(), results.hasMoreItems());
            }
        };
        return new CollectionIterable((AbstractPageFetcher)pageFetcher);
    }

    public ItemIterable<CmisObject> queryObjects(String typeId, String where, boolean searchAllVersions, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public QueryStatement createQueryStatement(String statement) {
        return new QueryStatementImpl((Session)this, statement);
    }

    public ItemIterable<Relationship> getRelationships(final ObjectId objectId, final boolean includeSubRelationshipTypes, final RelationshipDirection relationshipDirection, ObjectType type, final OperationContext context) {
        final String typeId = type == null ? null : type.getId();
        AbstractPageFetcher<Relationship> pageFetcher = new AbstractPageFetcher<Relationship>((long)context.getMaxItemsPerPage()){

            protected AbstractPageFetcher.Page<Relationship> fetchPage(long skipCount) {
                ObjectList relations = NuxeoSession.this.service.getObjectRelationships(NuxeoSession.this.repositoryId, objectId.getId(), includeSubRelationshipTypes, relationshipDirection, typeId, null, null, BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Relationship> page = new ArrayList<Relationship>();
                if (relations.getObjects() != null) {
                    for (ObjectData data : relations.getObjects()) {
                        NuxeoObject ob = data instanceof NuxeoObjectData ? NuxeoSession.this.objectFactory.convertObject(data, context) : NuxeoSession.this.getObject(data.getId(), context);
                        if (!(ob instanceof Relationship)) continue;
                        page.add((Relationship)ob);
                    }
                }
                return new AbstractPageFetcher.Page(page, relations.getNumItems(), relations.hasMoreItems());
            }
        };
        return new CollectionIterable((AbstractPageFetcher)pageFetcher);
    }

    public Acl getAcl(ObjectId objectId, boolean onlyBasicPermissions) {
        throw new CmisNotSupportedException();
    }

    public Acl setAcl(ObjectId objectId, List<Ace> aces) {
        throw new CmisNotSupportedException();
    }

    public Acl applyAcl(ObjectId objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public void applyPolicy(ObjectId objectId, ObjectId ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public void removePolicy(ObjectId objectId, ObjectId ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public void removeObjectFromCache(ObjectId objectId) {
    }

    public void removeObjectFromCache(String objectId) {
    }

    public void delete(ObjectId objectId) {
        this.delete(objectId, true);
    }

    public void delete(ObjectId objectId, boolean allVersions) {
        this.service.deleteObject(this.repositoryId, objectId.getId(), allVersions, null);
    }

    public ContentStream getContentStream(ObjectId docId) {
        return this.getContentStream(docId, null, null, null);
    }

    public ContentStream getContentStream(ObjectId docId, String streamId, BigInteger offset, BigInteger length) {
        if (docId == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        return this.service.getContentStream(this.repositoryId, docId.getId(), streamId, offset, length, null);
    }

    public ObjectType createType(TypeDefinition type) {
        throw new CmisNotSupportedException();
    }

    public ObjectType updateType(TypeDefinition type) {
        throw new CmisNotSupportedException();
    }

    public void deleteType(String typeId) {
        throw new CmisNotSupportedException();
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(List<CmisObject> objects, Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds) {
        ArrayList<BulkUpdateObjectIdAndChangeToken> idts = new ArrayList<BulkUpdateObjectIdAndChangeToken>(objects.size());
        for (CmisObject object : objects) {
            idts.add((BulkUpdateObjectIdAndChangeToken)new BulkUpdateObjectIdAndChangeTokenImpl(object.getId(), object.getChangeToken()));
        }
        return this.service.bulkUpdateProperties(this.repositoryId, idts, this.convertProperties(properties), addSecondaryTypeIds, removeSecondaryTypeIds, null);
    }
}

