/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderChangedListener;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractPageProvider<T>
implements PageProvider<T> {
    public static final Log log = LogFactory.getLog(AbstractPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected String name;
    protected long offset = 0L;
    protected long pageSize = 0L;
    protected long maxPageSize = this.getDefaultMaxPageSize();
    protected long resultsCount = -1L;
    protected int currentEntryIndex = 0;
    protected int currentHigherNonEmptyPageIndex = 0;
    protected List<SortInfo> sortInfos;
    protected boolean sortable = false;
    protected List<T> selectedEntries;
    protected PageSelections<T> currentSelectPage;
    protected Map<String, Serializable> properties;
    protected Object[] parameters;
    protected DocumentModel searchDocumentModel;
    protected String errorMessage;
    protected Throwable error;
    protected PageProviderDefinition definition;
    protected PageProviderChangedListener pageProviderChangedListener;

    @Override
    public abstract List<T> getCurrentPage();

    protected void pageChanged() {
        this.currentEntryIndex = 0;
        this.currentSelectPage = null;
        this.notifyPageChanged();
    }

    @Override
    public void firstPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        if (offset != 0L) {
            this.setCurrentPageOffset(0L);
            this.pageChanged();
        }
    }

    @Deprecated
    public void rewind() {
        this.firstPage();
    }

    @Override
    public long getCurrentPageIndex() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return 0L;
        }
        long offset = this.getCurrentPageOffset();
        return offset / pageSize;
    }

    @Override
    public long getCurrentPageOffset() {
        return this.offset;
    }

    @Override
    public void setCurrentPageOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getCurrentPageSize() {
        List<T> currentItems = this.getCurrentPage();
        if (currentItems != null) {
            return currentItems.size();
        }
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getNumberOfPages() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return 1L;
        }
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            return 0L;
        }
        return 1L + (resultsCount - 1L) / pageSize;
    }

    @Override
    public void setCurrentPageIndex(long currentPageIndex) {
        long pageSize = this.getPageSize();
        long offset = currentPageIndex * pageSize;
        this.setCurrentPageOffset(offset);
        this.pageChanged();
    }

    @Override
    public List<T> setCurrentPage(long page) {
        this.setCurrentPageIndex(page);
        return this.getCurrentPage();
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(long pageSize) {
        long localPageSize = this.getPageSize();
        if (localPageSize != pageSize) {
            this.pageSize = pageSize;
            this.setCurrentPageOffset(0L);
            this.refresh();
        }
    }

    @Override
    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            res.addAll(this.sortInfos);
        }
        return res;
    }

    @Override
    public SortInfo getSortInfo() {
        if (this.sortInfos != null && !this.sortInfos.isEmpty()) {
            return this.sortInfos.get(0);
        }
        return null;
    }

    protected boolean sortInfoChanged(List<SortInfo> oldSortInfos, List<SortInfo> newSortInfos) {
        if (oldSortInfos == null && newSortInfos == null) {
            return false;
        }
        if (oldSortInfos == null) {
            oldSortInfos = Collections.emptyList();
        } else if (newSortInfos == null) {
            newSortInfos = Collections.emptyList();
        }
        if (oldSortInfos.size() != newSortInfos.size()) {
            return true;
        }
        for (int i = 0; i < oldSortInfos.size(); ++i) {
            SortInfo oldSort = (SortInfo)oldSortInfos.get(i);
            SortInfo newSort = (SortInfo)newSortInfos.get(i);
            if (oldSort == null && newSort == null) continue;
            if (oldSort == null || newSort == null) {
                return true;
            }
            if (oldSort.equals((Object)newSort)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSortInfos(List<SortInfo> sortInfo) {
        if (this.sortInfoChanged(this.sortInfos, sortInfo)) {
            this.sortInfos = sortInfo;
            this.refresh();
        }
    }

    @Override
    public void setSortInfo(SortInfo sortInfo) {
        ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
        if (sortInfo != null) {
            newSortInfos.add(sortInfo);
        }
        this.setSortInfos(newSortInfos);
    }

    @Override
    public void setSortInfo(String sortColumn, boolean sortAscending, boolean removeOtherSortInfos) {
        if (removeOtherSortInfos) {
            SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
            this.setSortInfo(sortInfo);
        } else if (this.getSortInfoIndex(sortColumn, sortAscending) == -1) {
            if (this.getSortInfoIndex(sortColumn, !sortAscending) != -1) {
                ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
                for (SortInfo sortInfo : this.getSortInfos()) {
                    if (sortColumn.equals(sortInfo.getSortColumn())) {
                        newSortInfos.add(new SortInfo(sortColumn, sortAscending));
                        continue;
                    }
                    newSortInfos.add(sortInfo);
                }
                this.setSortInfos(newSortInfos);
            } else {
                this.addSortInfo(sortColumn, sortAscending);
            }
        }
    }

    @Override
    public void addSortInfo(String sortColumn, boolean sortAscending) {
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null) {
            this.setSortInfo(sortInfo);
        } else {
            sortInfos.add(sortInfo);
            this.setSortInfos(sortInfos);
        }
    }

    @Override
    public int getSortInfoIndex(String sortColumn, boolean sortAscending) {
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null || sortInfos.isEmpty()) {
            return -1;
        }
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        return sortInfos.indexOf(sortInfo);
    }

    @Override
    public boolean isNextPageAvailable() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return false;
        }
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            long currentPageIndex = this.getCurrentPageIndex();
            return currentPageIndex < (long)(this.getCurrentHigherNonEmptyPageIndex() + this.getMaxNumberOfEmptyPages());
        }
        long offset = this.getCurrentPageOffset();
        return resultsCount > pageSize + offset;
    }

    @Override
    public boolean isLastPageAvailable() {
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            return false;
        }
        return this.isNextPageAvailable();
    }

    @Override
    public boolean isPreviousPageAvailable() {
        long offset = this.getCurrentPageOffset();
        return offset > 0L;
    }

    @Override
    public void lastPage() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L || resultsCount < 0L) {
            return;
        }
        if (resultsCount % pageSize == 0L) {
            this.setCurrentPageOffset(resultsCount - pageSize);
        } else {
            this.setCurrentPageOffset(resultsCount - resultsCount % pageSize);
        }
        this.pageChanged();
    }

    @Deprecated
    public void last() {
        this.lastPage();
    }

    @Override
    public void nextPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        this.setCurrentPageOffset(offset += pageSize);
        this.pageChanged();
    }

    @Deprecated
    public void next() {
        this.nextPage();
    }

    @Override
    public void previousPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        if (offset >= pageSize) {
            this.setCurrentPageOffset(offset -= pageSize);
            this.pageChanged();
        }
    }

    @Deprecated
    public void previous() {
        this.previousPage();
    }

    @Override
    public void refresh() {
        this.setResultsCount(-1L);
        this.setCurrentHigherNonEmptyPageIndex(-1);
        this.currentSelectPage = null;
        this.errorMessage = null;
        this.error = null;
        this.notifyRefresh();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCurrentPageStatus() {
        long total = this.getNumberOfPages();
        long current = this.getCurrentPageIndex() + 1L;
        if (total <= 0L) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    @Override
    public boolean isNextEntryAvailable() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L) {
            if (resultsCount < 0L) {
                long currentPageSize = this.getCurrentPageSize();
                return (long)this.currentEntryIndex < currentPageSize - 1L;
            }
            return (long)this.currentEntryIndex < resultsCount - 1L;
        }
        long currentPageSize = this.getCurrentPageSize();
        if ((long)this.currentEntryIndex < currentPageSize - 1L) {
            return true;
        }
        if (resultsCount < 0L) {
            return false;
        }
        return this.isNextPageAvailable();
    }

    @Override
    public boolean isPreviousEntryAvailable() {
        return this.currentEntryIndex != 0 || this.isPreviousPageAvailable();
    }

    @Override
    public void nextEntry() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L) {
            if (resultsCount < 0L) {
                long currentPageSize = this.getCurrentPageSize();
                if ((long)this.currentEntryIndex < currentPageSize - 1L) {
                    ++this.currentEntryIndex;
                    return;
                }
            } else if ((long)this.currentEntryIndex < resultsCount - 1L) {
                ++this.currentEntryIndex;
                return;
            }
        } else {
            long currentPageSize = this.getCurrentPageSize();
            if ((long)this.currentEntryIndex < currentPageSize - 1L) {
                ++this.currentEntryIndex;
                return;
            }
            if (resultsCount >= 0L && this.isNextPageAvailable()) {
                this.nextPage();
                this.currentEntryIndex = 0;
                return;
            }
        }
    }

    @Override
    public void previousEntry() {
        if (this.currentEntryIndex > 0) {
            --this.currentEntryIndex;
            return;
        }
        if (!this.isPreviousPageAvailable()) {
            return;
        }
        this.previousPage();
        List<T> currentPage = this.getCurrentPage();
        this.currentEntryIndex = currentPage == null || currentPage.isEmpty() ? 0 : new Long(this.getPageSize() - 1L).intValue();
    }

    @Override
    public T getCurrentEntry() {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            return null;
        }
        return currentPage.get(this.currentEntryIndex);
    }

    @Override
    public void setCurrentEntry(T entry) throws ClientException {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new ClientException(String.format("Entry '%s' not found in current page", entry));
        }
        int i = currentPage.indexOf(entry);
        if (i == -1) {
            throw new ClientException(String.format("Entry '%s' not found in current page", entry));
        }
        this.currentEntryIndex = i;
    }

    @Override
    public void setCurrentEntryIndex(long index) throws ClientException {
        int intIndex = new Long(index).intValue();
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new ClientException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        if (index >= (long)currentPage.size()) {
            throw new ClientException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        this.currentEntryIndex = intIndex;
    }

    @Override
    public long getResultsCount() {
        return this.resultsCount;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return new HashMap<String, Serializable>(this.properties);
    }

    @Override
    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    @Override
    public void setResultsCount(long resultsCount) {
        this.resultsCount = resultsCount;
        this.setCurrentHigherNonEmptyPageIndex(-1);
    }

    @Override
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public PageSelections<T> getCurrentSelectPage() {
        if (this.currentSelectPage == null) {
            ArrayList entries = new ArrayList();
            List<T> currentPage = this.getCurrentPage();
            this.currentSelectPage = new PageSelections();
            this.currentSelectPage.setName(this.name);
            if (currentPage != null && !currentPage.isEmpty()) {
                if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
                    for (int i = 0; i < currentPage.size(); ++i) {
                        entries.add(new PageSelection<T>(currentPage.get(i), false));
                    }
                } else {
                    boolean allSelected = true;
                    for (int i = 0; i < currentPage.size(); ++i) {
                        T entry = currentPage.get(i);
                        Boolean selected = this.selectedEntries.contains(entry);
                        if (!Boolean.TRUE.equals(selected)) {
                            allSelected = false;
                        }
                        entries.add(new PageSelection<T>(entry, selected));
                    }
                    if (allSelected) {
                        this.currentSelectPage.setSelected(true);
                    }
                }
            }
            this.currentSelectPage.setEntries(entries);
        }
        return this.currentSelectPage;
    }

    @Override
    public void setSelectedEntries(List<T> entries) {
        this.selectedEntries = entries;
        this.currentSelectPage = null;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public DocumentModel getSearchDocumentModel() {
        return this.searchDocumentModel;
    }

    protected boolean searchDocumentModelChanged(DocumentModel oldDoc, DocumentModel newDoc) {
        if (oldDoc == null && newDoc == null) {
            return false;
        }
        if (oldDoc == null || newDoc == null) {
            return true;
        }
        return true;
    }

    @Override
    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        if (this.searchDocumentModelChanged(this.searchDocumentModel, searchDocumentModel)) {
            this.refresh();
        }
        this.searchDocumentModel = searchDocumentModel;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public PageProviderDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(PageProviderDefinition providerDefinition) {
        this.definition = providerDefinition;
    }

    @Override
    public long getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public void setMaxPageSize(long maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public long getMinMaxPageSize() {
        long pageSize = this.getPageSize();
        long maxPageSize = this.getMaxPageSize();
        if (maxPageSize < 0L) {
            maxPageSize = this.getDefaultMaxPageSize();
        }
        if (pageSize <= 0L) {
            return maxPageSize;
        }
        if (maxPageSize > 0L && maxPageSize < pageSize) {
            return maxPageSize;
        }
        return pageSize;
    }

    public int getCurrentHigherNonEmptyPageIndex() {
        return this.currentHigherNonEmptyPageIndex;
    }

    @Override
    public long getPageLimit() {
        return -1L;
    }

    public void setCurrentHigherNonEmptyPageIndex(int higherFilledPageIndex) {
        this.currentHigherNonEmptyPageIndex = higherFilledPageIndex;
    }

    public int getMaxNumberOfEmptyPages() {
        return 1;
    }

    protected long getDefaultMaxPageSize() {
        String maxPageSize;
        long res = 100L;
        if (Framework.isInitialized() && !StringUtils.isBlank((String)(maxPageSize = Framework.getProperty((String)"nuxeo.pageprovider.default-max-page-size")))) {
            try {
                res = Long.parseLong(maxPageSize.trim());
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Invalid max page size defined for property \"%s\": %s (waiting for a long value)", "nuxeo.pageprovider.default-max-page-size", maxPageSize));
            }
        }
        return res;
    }

    @Override
    public void setPageProviderChangedListener(PageProviderChangedListener listener) {
        this.pageProviderChangedListener = listener;
    }

    protected void notifyPageChanged() {
        if (this.pageProviderChangedListener != null) {
            this.pageProviderChangedListener.pageChanged(this);
        }
    }

    protected void notifyRefresh() {
        if (this.pageProviderChangedListener != null) {
            this.pageProviderChangedListener.refreshed(this);
        }
    }

    @Override
    public boolean hasChangedParameters(Object[] parameters) {
        return this.getParametersChanged(this.getParameters(), parameters);
    }

    protected boolean getParametersChanged(Object[] oldParams, Object[] newParams) {
        if (oldParams == null && newParams == null) {
            return true;
        }
        if (oldParams != null && newParams != null) {
            if (oldParams.length != newParams.length) {
                return true;
            }
            for (int i = 0; i < oldParams.length; ++i) {
                if (oldParams[i] == null && newParams[i] == null) continue;
                if (oldParams[i] != null && !oldParams[i].equals(newParams[i])) {
                    return true;
                }
                if (newParams[i] == null || newParams[i].equals(oldParams[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

