/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.concurrent.CountDownLatch;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class SleepWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected long durationMillis;
    protected String category;
    protected transient boolean debug;
    protected transient CountDownLatch readyLatch = new CountDownLatch(1);
    protected transient CountDownLatch doneLatch = new CountDownLatch(1);
    protected transient CountDownLatch startLatch = new CountDownLatch(1);
    protected transient CountDownLatch finishLatch = new CountDownLatch(1);

    public SleepWork(long durationMillis) {
        this(durationMillis, "SleepWork", false);
    }

    public SleepWork(long durationMillis, boolean debug) {
        this(durationMillis, "SleepWork", debug);
    }

    public SleepWork(long durationMillis, boolean debug, String id) {
        this(durationMillis, "SleepWork", debug, id);
    }

    public SleepWork(long durationMillis, String category, boolean debug) {
        this.init(durationMillis, category, debug);
    }

    public SleepWork(long durationMillis, String category, boolean debug, String id) {
        super(id);
        this.init(durationMillis, category, debug);
    }

    private void init(long durationMillis, String category, boolean debug) {
        this.durationMillis = durationMillis;
        this.category = category;
        this.debug = debug;
        this.setProgress(Work.Progress.PROGRESS_0_PC);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTitle() {
        return "Sleep " + this.durationMillis + " ms";
    }

    @Override
    public void work() throws InterruptedException {
        long elapsed;
        if (this.debug) {
            this.setStatus("Starting sleep work");
            this.readyLatch.countDown();
            this.startLatch.await();
            this.setStatus("Running sleep work");
        }
        this.startTime = System.currentTimeMillis();
        while ((elapsed = System.currentTimeMillis() - this.startTime) <= this.durationMillis) {
            this.setProgress(new Work.Progress(100.0f * (float)elapsed / (float)this.durationMillis));
            if (this.isSuspending()) {
                this.durationMillis -= elapsed;
                this.suspended();
                if (this.debug) {
                    this.doneLatch.countDown();
                    this.finishLatch.await();
                }
                return;
            }
            Thread.sleep(10L);
        }
        if (this.debug) {
            this.setStatus("Completed sleep work");
            this.setProgress(Work.Progress.PROGRESS_100_PC);
            this.doneLatch.countDown();
            this.finishLatch.await();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.getId().length() > 10 ? "" : this.getId() + ", ") + this.durationMillis + "ms, " + this.getProgress() + ")";
    }

    public void debugWaitReady() throws InterruptedException {
        this.readyLatch.await();
    }

    public void debugWaitDone() throws InterruptedException {
        this.doneLatch.await();
    }

    public void debugStart() {
        this.startLatch.countDown();
    }

    public void debugFinish() {
        this.finishLatch.countDown();
    }
}

