/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.redis.RedisService;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.redis.RedisBlockingQueue;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisWorkQueuing
implements WorkQueuing {
    private static final Log log = LogFactory.getLog(RedisWorkQueuing.class);
    protected static final String UTF_8 = "UTF-8";
    protected static final String KEY_DATA = "data";
    protected static final String KEY_STATE = "state";
    protected static final String KEY_SUSPENDED_PREFIX = "prev:";
    protected static final String KEY_SCHEDULED_PREFIX = "queue:";
    protected static final String KEY_RUNNING_PREFIX = "run:";
    protected static final String KEY_COMPLETED_PREFIX = "done:";
    protected static final byte STATE_SCHEDULED_B = 81;
    protected static final byte STATE_CANCELED_B = 88;
    protected static final byte STATE_RUNNING_B = 82;
    protected static final byte STATE_COMPLETED_B = 67;
    protected static final byte[] STATE_SCHEDULED = new byte[]{81};
    protected static final byte[] STATE_CANCELED = new byte[]{88};
    protected static final byte[] STATE_RUNNING = new byte[]{82};
    protected static final byte[] STATE_COMPLETED = new byte[]{67};
    protected Map<String, BlockingQueue<Runnable>> allScheduled = new HashMap<String, BlockingQueue<Runnable>>();
    protected RedisService redisService;
    protected String redisPrefix;

    public RedisWorkQueuing(WorkQueueDescriptorRegistry workQueueDescriptors) {
    }

    @Override
    public void init() {
        try {
            for (String queueId : this.getSuspendedQueueIds()) {
                int n = this.scheduleSuspendedWork(queueId);
                log.info((Object)("Re-scheduling " + n + " work instances suspended from queue: " + queueId));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized BlockingQueue<Runnable> getScheduledQueue(String queueId) {
        BlockingQueue<Runnable> scheduled = this.allScheduled.get(queueId);
        if (scheduled == null) {
            scheduled = this.newBlockingQueue(queueId);
            this.allScheduled.put(queueId, scheduled);
        }
        return scheduled;
    }

    @Override
    public void workRunning(String queueId, Work work) {
        try {
            this.workSetRunning(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void workCompleted(String queueId, Work work) {
        try {
            this.workSetCompleted(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected BlockingQueue<Runnable> newBlockingQueue(String queueId) {
        return new RedisBlockingQueue(queueId, this);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.listScheduled(queueId);
            }
            case RUNNING: {
                return this.listRunning(queueId);
            }
            case COMPLETED: {
                return this.listCompleted(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        if (state == null) {
            return this.listNonCompletedIds(queueId);
        }
        switch (state) {
            case SCHEDULED: {
                return this.listScheduledIds(queueId);
            }
            case RUNNING: {
                return this.listRunningIds(queueId);
            }
            case COMPLETED: {
                return this.listCompletedIds(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    protected List<Work> listScheduled(String queueId) {
        try {
            return this.listWorkList(this.scheduledKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Work> listRunning(String queueId) {
        try {
            return this.listWorkSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Work> listCompleted(String queueId) {
        try {
            return this.listWorkSet(this.completedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listScheduledIds(String queueId) {
        try {
            return this.listWorkIdsList(this.scheduledKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listRunningIds(String queueId) {
        try {
            return this.listWorkIdsSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listNonCompletedIds(String queueId) {
        List<String> list = this.listScheduledIds(queueId);
        list.addAll(this.listRunningIds(queueId));
        return list;
    }

    protected List<String> listCompletedIds(String queueId) {
        try {
            return this.listWorkIdsSet(this.completedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.getScheduledSize(queueId);
            }
            case RUNNING: {
                return this.getRunningSize(queueId);
            }
            case COMPLETED: {
                return this.getCompletedSize(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    protected int getScheduledSize(String queueId) {
        try {
            return this.getScheduledQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getRunningSize(String queueId) {
        try {
            return this.getRunningQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getCompletedSize(String queueId) {
        try {
            return this.getCompletedQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Work find(String workId, Work.State state) {
        if (this.isWorkInState(workId, state)) {
            return this.getWork(RedisWorkQueuing.bytes(workId));
        }
        return null;
    }

    @Override
    public boolean isWorkInState(String workId, Work.State state) {
        Work.State s = this.getWorkState(workId);
        if (state == null) {
            return s == Work.State.SCHEDULED || s == Work.State.RUNNING;
        }
        return s == state;
    }

    @Override
    public Work removeScheduled(String queueId, String workId) {
        try {
            return this.removeScheduledWork(queueId, workId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Work.State getWorkState(String workId) {
        try {
            return this.getWorkStateInfo(workId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int setSuspending(String queueId) {
        try {
            int n = this.suspendScheduledWork(queueId);
            log.info((Object)("Suspending " + n + " work instances from queue: " + queueId));
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearCompletedWork(String queueId, long completionTime) {
        try {
            if (completionTime <= 0L) {
                this.removeAllCompletedWork(queueId);
            } else {
                this.removeCompletedWork(queueId, completionTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected RedisService getRedisService() {
        if (this.redisService == null) {
            this.redisService = (RedisService)Framework.getLocalService(RedisService.class);
            this.redisPrefix = this.redisService.getPrefix();
        }
        return this.redisService;
    }

    protected Jedis getJedis() {
        RedisService redisService = this.getRedisService();
        if (redisService == null) {
            return null;
        }
        JedisPool jedisPool = redisService.getJedisPool();
        if (jedisPool == null) {
            return null;
        }
        return (Jedis)jedisPool.getResource();
    }

    protected void closeJedis(Jedis jedis) {
        this.getRedisService().getJedisPool().returnResource((Object)jedis);
    }

    protected static String string(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static byte[] bytes(String string) {
        try {
            return string.getBytes(UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[] keyBytes(String prefix, String queueId) {
        return RedisWorkQueuing.bytes(this.redisPrefix + prefix + queueId);
    }

    protected byte[] keyBytes(String prefix) {
        return RedisWorkQueuing.bytes(this.redisPrefix + prefix);
    }

    protected byte[] suspendedKey(String queueId) {
        return this.keyBytes(KEY_SUSPENDED_PREFIX, queueId);
    }

    protected byte[] scheduledKey(String queueId) {
        return this.keyBytes(KEY_SCHEDULED_PREFIX, queueId);
    }

    protected byte[] runningKey(String queueId) {
        return this.keyBytes(KEY_RUNNING_PREFIX, queueId);
    }

    protected byte[] completedKey(String queueId) {
        return this.keyBytes(KEY_COMPLETED_PREFIX, queueId);
    }

    protected byte[] stateKey() {
        return this.keyBytes(KEY_STATE);
    }

    protected byte[] dataKey() {
        return this.keyBytes(KEY_DATA);
    }

    protected byte[] serializeWork(Work work) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baout);
        out.writeObject(work);
        out.flush();
        out.close();
        return baout.toByteArray();
    }

    protected Work deserializeWork(byte[] workBytes) throws IOException {
        if (workBytes == null) {
            return null;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(workBytes);
        ObjectInputStream in = new ObjectInputStream(bain);
        try {
            return (Work)in.readObject();
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getScheduledQueueSize(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Long len = jedis.llen(this.scheduledKey(queueId));
            int n = len.intValue();
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRunningQueueSize(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Long len = jedis.scard(this.runningKey(queueId));
            int n = len.intValue();
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCompletedQueueSize(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Long len = jedis.scard(this.completedKey(queueId));
            int n = len.intValue();
            return n;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    protected void storeWork(byte[] workIdBytes, byte[] workBytes, Jedis jedis) {
        jedis.hset(this.dataKey(), workIdBytes, workBytes);
        jedis.hset(this.stateKey(), workIdBytes, STATE_SCHEDULED);
    }

    protected void removeWork(byte[] workIdBytes, Jedis jedis) {
        jedis.hdel(this.stateKey(), (byte[][])new byte[][]{workIdBytes});
        jedis.hdel(this.dataKey(), (byte[][])new byte[][]{workIdBytes});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScheduledWork(String queueId, Work work) throws IOException {
        byte[] workIdBytes = RedisWorkQueuing.bytes(work.getId());
        byte[] workBytes = this.serializeWork(work);
        Jedis jedis = this.getJedis();
        try {
            this.storeWork(workIdBytes, workBytes, jedis);
            jedis.lpush(this.scheduledKey(queueId), (byte[][])new byte[][]{workIdBytes});
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public Work removeScheduled(String queueId) {
        try {
            return this.removeScheduledWork(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<String> getSuspendedQueueIds() throws IOException {
        return this.getQueueIds(KEY_SUSPENDED_PREFIX);
    }

    protected Set<String> getScheduledQueueIds() {
        try {
            return this.getQueueIds(KEY_SCHEDULED_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<String> getRunningQueueIds() {
        try {
            return this.getQueueIds(KEY_RUNNING_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> getCompletedQueueIds() {
        try {
            return this.getQueueIds(KEY_COMPLETED_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getQueueIds(String prefix) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            int offset = this.keyBytes(prefix).length;
            Set keys = jedis.keys(this.keyBytes(prefix, "*"));
            HashSet<String> queueIds = new HashSet<String>(keys.size());
            for (byte[] bytes : keys) {
                String queueId = new String(bytes, offset, bytes.length - offset, UTF_8);
                queueIds.add(queueId);
            }
            HashSet<String> hashSet = queueIds;
            return hashSet;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public int scheduleSuspendedWork(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            int n = 0;
            while (true) {
                byte[] workIdBytes;
                if ((workIdBytes = jedis.rpoplpush(this.suspendedKey(queueId), this.scheduledKey(queueId))) == null) {
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    public int suspendScheduledWork(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            int n = 0;
            while (true) {
                byte[] workIdBytes;
                if ((workIdBytes = jedis.rpoplpush(this.scheduledKey(queueId), this.suspendedKey(queueId))) == null) {
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workSetRunning(String queueId, Work work) throws IOException {
        byte[] workIdBytes = RedisWorkQueuing.bytes(work.getId());
        Jedis jedis = this.getJedis();
        try {
            jedis.sadd(this.runningKey(queueId), (byte[][])new byte[][]{workIdBytes});
            jedis.hset(this.stateKey(), workIdBytes, STATE_RUNNING);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workSetCompleted(String queueId, Work work) throws IOException {
        byte[] workIdBytes = RedisWorkQueuing.bytes(work.getId());
        byte[] workBytes = this.serializeWork(work);
        Jedis jedis = this.getJedis();
        try {
            jedis.hset(this.dataKey(), workIdBytes, workBytes);
            jedis.srem(this.runningKey(queueId), (byte[][])new byte[][]{workIdBytes});
            jedis.sadd(this.completedKey(queueId), (byte[][])new byte[][]{workIdBytes});
            byte[] completedBytes = RedisWorkQueuing.bytes('C' + String.valueOf(work.getCompletionTime()));
            jedis.hset(this.stateKey(), workIdBytes, completedBytes);
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work.State getWorkStateInfo(String workId) throws IOException {
        byte[] workIdBytes = RedisWorkQueuing.bytes(workId);
        Jedis jedis = this.getJedis();
        try {
            byte[] bytes = jedis.hget(this.stateKey(), workIdBytes);
            if (bytes == null || bytes.length == 0) {
                Work.State state = null;
                return state;
            }
            switch (bytes[0]) {
                case 81: {
                    Work.State state = Work.State.SCHEDULED;
                    return state;
                }
                case 88: {
                    Work.State state = Work.State.CANCELED;
                    return state;
                }
                case 82: {
                    Work.State state = Work.State.RUNNING;
                    return state;
                }
                case 67: {
                    Work.State state = Work.State.COMPLETED;
                    return state;
                }
            }
            log.error((Object)("Unknown work state: " + new String(bytes, UTF_8) + ", work: " + workId));
            Work.State state = null;
            return state;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> listWorkIdsList(byte[] queueBytes) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            List keys = jedis.lrange(queueBytes, 0L, -1L);
            ArrayList<String> list = new ArrayList<String>(keys.size());
            for (byte[] workIdBytes : keys) {
                list.add(RedisWorkQueuing.string(workIdBytes));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> listWorkIdsSet(byte[] queueBytes) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Set keys = jedis.smembers(queueBytes);
            ArrayList<String> list = new ArrayList<String>(keys.size());
            for (byte[] workIdBytes : keys) {
                list.add(RedisWorkQueuing.string(workIdBytes));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Work> listWorkList(byte[] queueBytes) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            List keys = jedis.lrange(queueBytes, 0L, -1L);
            ArrayList<Work> list = new ArrayList<Work>(keys.size());
            for (byte[] workIdBytes : keys) {
                byte[] workBytes = jedis.hget(this.dataKey(), workIdBytes);
                Work work = this.deserializeWork(workBytes);
                list.add(work);
            }
            ArrayList<Work> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Work> listWorkSet(byte[] queueBytes) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Set keys = jedis.smembers(queueBytes);
            ArrayList<Work> list = new ArrayList<Work>(keys.size());
            for (byte[] workIdBytes : keys) {
                byte[] workBytes = jedis.hget(this.dataKey(), workIdBytes);
                Work work = this.deserializeWork(workBytes);
                list.add(work);
            }
            ArrayList<Work> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    protected Work getWork(byte[] workIdBytes) {
        try {
            return this.getWorkData(workIdBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work getWorkData(byte[] workIdBytes) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            byte[] workBytes = jedis.hget(this.dataKey(), workIdBytes);
            Work work = this.deserializeWork(workBytes);
            return work;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work removeScheduledWork(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            byte[] workIdBytes = jedis.rpop(this.scheduledKey(queueId));
            if (workIdBytes == null) {
                Work work = null;
                return work;
            }
            byte[] workBytes = jedis.hget(this.dataKey(), workIdBytes);
            Work work = this.deserializeWork(workBytes);
            return work;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Work removeScheduledWork(String queueId, String workId) throws IOException {
        byte[] workIdBytes = RedisWorkQueuing.bytes(workId);
        Jedis jedis = this.getJedis();
        try {
            Long n = jedis.lrem(this.scheduledKey(queueId), 0L, workIdBytes);
            if (n == null || n.intValue() == 0) {
                Work work = null;
                return work;
            }
            byte[] completedBytes = RedisWorkQueuing.bytes(String.valueOf(System.currentTimeMillis()));
            jedis.hset(this.stateKey(), workIdBytes, completedBytes);
            byte[] workBytes = jedis.hget(this.dataKey(), workIdBytes);
            Work work = this.deserializeWork(workBytes);
            return work;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    protected void removeAllCompletedWork(String queueId) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            while (true) {
                byte[] workIdBytes;
                if ((workIdBytes = jedis.spop(this.completedKey(queueId))) == null) {
                    return;
                }
                this.removeWork(workIdBytes, jedis);
            }
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCompletedWork(String queueId, long completionTime) throws IOException {
        Jedis jedis = this.getJedis();
        try {
            Set keys = jedis.smembers(this.completedKey(queueId));
            for (byte[] workIdBytes : keys) {
                long t;
                byte[] bytes = jedis.hget(this.stateKey(), workIdBytes);
                if (bytes == null || bytes.length == 0 || bytes[0] != 67 || (t = Long.parseLong(new String(bytes, 1, bytes.length - 1, UTF_8))) >= completionTime) continue;
                jedis.srem(this.completedKey(queueId), (byte[][])new byte[][]{workIdBytes});
                this.removeWork(workIdBytes, jedis);
            }
        }
        finally {
            this.closeJedis(jedis);
        }
    }
}

