/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.web;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionsManager;
import org.nuxeo.ecm.platform.publisher.web.AbstractPublishActions;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="adminPublishActions")
@Scope(value=ScopeType.CONVERSATION)
public class AdministrationPublishActions
extends AbstractPublishActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AdministrationPublishActions.class);
    public static final String PUBLICATION_TREE_PLUGIN_NAME = "publication";
    protected transient RootSectionFinder rootFinder;
    protected transient RootSectionsManager rootSectionsManager;
    protected transient TreeManager treeManager;
    protected DocumentTreeNode sectionsTree;
    protected DocumentModelList sectionRoots;
    protected String currentSectionRootId;

    @Create
    public void create() {
        this.rootSectionsManager = new RootSectionsManager(this.documentManager);
    }

    @Factory(value="defaultPublishingRoots", scope=ScopeType.EVENT)
    public DocumentModelList getSectionRoots() throws ClientException {
        return this.getRootFinder().getDefaultSectionRoots(true, true);
    }

    protected RootSectionFinder getRootFinder() {
        if (this.rootFinder == null) {
            PublisherService ps = (PublisherService)Framework.getLocalService(PublisherService.class);
            this.rootFinder = ps.getRootSectionFinder(this.documentManager);
        }
        return this.rootFinder;
    }

    public String getCurrentSectionRootId() {
        return this.currentSectionRootId;
    }

    public DocumentTreeNode getCurrentSectionsTree() throws ClientException {
        DocumentModel sectionsRoot = null;
        this.sectionRoots = this.getSectionRoots();
        if (this.currentSectionRootId == null && this.sectionRoots.size() > 0) {
            this.currentSectionRootId = ((DocumentModel)this.sectionRoots.get(0)).getId();
        }
        if (this.currentSectionRootId != null) {
            sectionsRoot = this.documentManager.getDocument((DocumentRef)new IdRef(this.currentSectionRootId));
        }
        this.sectionsTree = this.getDocumentTreeNode(sectionsRoot);
        return this.sectionsTree;
    }

    public void setCurrentSectionRootId(String currentSectionRootId) {
        this.currentSectionRootId = currentSectionRootId;
    }

    protected DocumentTreeNode getDocumentTreeNode(DocumentModel documentModel) {
        DocumentTreeNodeImpl documentTreeNode = null;
        if (documentModel != null) {
            Filter filter = null;
            Sorter sorter = null;
            try {
                filter = this.getTreeManager().getFilter(PUBLICATION_TREE_PLUGIN_NAME);
                sorter = this.getTreeManager().getSorter(PUBLICATION_TREE_PLUGIN_NAME);
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            documentTreeNode = new DocumentTreeNodeImpl(documentModel, filter, sorter);
        }
        return documentTreeNode;
    }

    protected TreeManager getTreeManager() {
        if (this.treeManager == null) {
            try {
                this.treeManager = (TreeManager)Framework.getService(TreeManager.class);
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch Tree Manager ", (Throwable)e);
            }
        }
        return this.treeManager;
    }

    public boolean canAddSection(DocumentModel section) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.rootSectionsManager.canAddSection(section, currentDocument);
    }

    public String addSection(String sectionId) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.rootSectionsManager.addSection(sectionId, currentDocument);
        this.getRootFinder().reset();
        return null;
    }

    public DocumentModelList getSelectedSections() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getRootFinder().getSectionRootsForWorkspace(currentDocument, true);
    }

    public String removeSection(String sectionId) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.rootSectionsManager.removeSection(sectionId, currentDocument);
        this.getRootFinder().reset();
        return null;
    }

    protected static String formatPathFragments(List<String> pathFragments) {
        String fullPath = "";
        for (String aFragment : pathFragments) {
            if (!"".equals(fullPath)) {
                fullPath = ">" + fullPath;
            }
            fullPath = aFragment + fullPath;
        }
        return fullPath;
    }

    @Override
    protected DocumentModel getParentDocument(DocumentModel documentModel) throws ClientException {
        try {
            return this.documentManager.getDocument(documentModel.getParentRef());
        }
        catch (Exception e) {
            log.error((Object)"Error building path", (Throwable)e);
            return null;
        }
    }
}

